/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class XsuaaUtils {
    private static final String XSUAA = "xsuaa";
    private final CdsRuntime runtime;

    public XsuaaUtils(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public List<ServiceBinding> getXsuaaServiceBindings() {
        Stream<ServiceBinding> xsuaaBindings = this.runtime.getEnvironment().getServiceBindings().filter(b -> b.matches(XSUAA, XSUAA));
        String xsuaaServiceBinding = this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().getBinding();
        if (!StringUtils.isEmpty(xsuaaServiceBinding)) {
            xsuaaBindings = xsuaaBindings.filter(b -> xsuaaServiceBinding.equalsIgnoreCase(b.getName()));
        }
        return xsuaaBindings.collect(Collectors.toList());
    }

    public boolean xsuaaConfiguredCondition() {
        return this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isEnabled() != false && !this.getXsuaaServiceBindings().isEmpty();
    }
}

