/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging;

import com.sap.cds.services.environment.ApplicationInfo;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagingUtils.class);

    public static String getQueueName(String service, ApplicationInfo config) {
        String qualifier;
        String name;
        StringBuilder queue = new StringBuilder(MessagingUtils.normalizeName(config.getName()));
        int lastIdx = service.lastIndexOf(46);
        if (lastIdx > 0) {
            name = service.substring(lastIdx + 1);
            qualifier = service.substring(0, lastIdx);
        } else {
            name = service;
            qualifier = "";
        }
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(config.getId()));
        queue.append('/');
        queue.append(MessagingUtils.normalizeName(name));
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(qualifier));
        return queue.toString();
    }

    private static String normalizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9\\*\\.]", "").replace('.', '/');
    }

    private static String getShortHash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length && i < 2; ++i) {
                sb.append(String.format("%02x", digest[i] & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Could not get MD5 algorithm", (Throwable)e);
            return text;
        }
    }
}

