/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.jms;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.messaging.jms.BrokerConnection;
import com.sap.cds.services.utils.rest.client.JsonRestClientConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrokerConnectionProvider<T extends JsonRestClientConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(BrokerConnectionProvider.class);
    private final T brokerConfiguration;
    private Map<Map<String, String>, BrokerConnection> configuredConnections = new HashMap<Map<String, String>, BrokerConnection>();

    public BrokerConnectionProvider(T brokerConfiguration) {
        this.brokerConfiguration = brokerConfiguration;
    }

    public T getBrokerConfiguration() {
        return this.brokerConfiguration;
    }

    public synchronized void asyncConnectionInitialization(CdsProperties.Messaging.MessagingServiceConfig config, Consumer<BrokerConnection> consumer) {
        try {
            BrokerConnection connection = this.createConnection(config);
            this.run(() -> {
                BrokerConnection brokerConnection = connection;
                synchronized (brokerConnection) {
                    if (!connection.isConnected()) {
                        logger.info("Initializing messaging connection '{}'", (Object)connection.getName());
                        try {
                            connection.connect();
                            logger.debug("Finished initializing messaging connection '{}'", (Object)connection.getName());
                        }
                        catch (Throwable th) {
                            logger.warn("Could not initialize messaging connection '{}'", (Object)connection.getName(), (Object)th);
                        }
                    }
                }
                consumer.accept(connection);
            });
        }
        catch (Throwable th) {
            throw new ErrorStatusException(CdsErrorStatuses.INVALID_BROKER_CONFIGURATION, config.getName(), th);
        }
    }

    private BrokerConnection createConnection(CdsProperties.Messaging.MessagingServiceConfig config) {
        try {
            if (config.getConnection().isDedicated()) {
                return this.createBrokerConnection(config.getName(), config.getConnection().getProperties());
            }
            BrokerConnection connection = this.configuredConnections.entrySet().stream().filter(e -> StringUtils.equalsMapIgnoreCase((Map)e.getKey(), config.getConnection().getProperties())).map(e -> (BrokerConnection)e.getValue()).findFirst().orElse(null);
            if (connection == null) {
                String connectionName = "shared-" + this.brokerConfiguration.getName() + "-" + this.configuredConnections.size();
                connection = this.createBrokerConnection(connectionName, config.getConnection().getProperties());
                this.configuredConnections.put(config.getConnection().getProperties(), connection);
            }
            return connection;
        }
        catch (Throwable th) {
            throw new ErrorStatusException(CdsErrorStatuses.INVALID_BROKER_CONFIGURATION, this.brokerConfiguration.getName(), th);
        }
    }

    private void run(Runnable action) {
        Thread runner = new Thread(action, this.brokerConfiguration.getName() + " - Initializer");
        runner.setDaemon(true);
        runner.start();
    }

    protected abstract BrokerConnection createBrokerConnection(String var1, Map<String, String> var2) throws Exception;
}

