/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.service;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.messaging.service.MessageQueue;
import com.sap.cds.services.utils.messaging.service.MessageTopic;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingBrokerQueueListener {
    private static final Logger logger = LoggerFactory.getLogger(MessagingBrokerQueueListener.class);
    private final Service service;
    private final String queueName;
    private final MessageQueue queue;
    private final CdsRuntime runtime;

    public MessagingBrokerQueueListener(Service service, String queueName, MessageQueue queue, CdsRuntime runtime) {
        this.service = service;
        this.queueName = queueName;
        this.queue = queue;
        this.runtime = runtime;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void receivedMessage(String message, String brokerTopicName, String messageId) {
        logger.debug("Received message on service '{}' from topic '{}' and queue '{}'.", new Object[]{this.service.getName(), brokerTopicName, this.queueName});
        List<MessageTopic> topics = this.queue.findTopic(brokerTopicName);
        topics.forEach(topic -> {
            try {
                logger.debug("The message from topic '{}' on service '{}' is going to be emitted as a service event '{}'", new Object[]{topic.getBrokerName(), this.service.getName(), topic.getEventName()});
                this.runtime.requestContext().privilegedUser().run(req -> {
                    TopicMessageEventContext context = this.getContext(message, topic.getEventName(), messageId);
                    this.service.emit((EventContext)context);
                });
            }
            catch (Exception e) {
                throw new ErrorStatusException(CdsErrorStatuses.EVENT_PROCESSING_FAILED, topic.getEventName(), this.service.getName(), this.queueName, e);
            }
        });
    }

    private TopicMessageEventContext getContext(String message, String eventTopicName, String messageId) {
        TopicMessageEventContext context = TopicMessageEventContext.create((String)eventTopicName);
        context.setData(message);
        context.setMessageId(messageId);
        context.setIsInbound(true);
        return context;
    }
}

