/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.utils.rest.client.JsonRestClientConfiguration;
import com.sap.cds.services.utils.rest.client.JsonRestClientResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(JsonRestClient.class);
    private static final String UTF_8 = "UTF-8";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String GRANT_TYPE = "grant_type";
    private static final String JSON_CONTENT = "application/json";
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACESS_TOKEN = "access_token";
    private static final String APP_FORM_ENC = "application/x-www-form-urlencoded";
    protected final ObjectMapper mapper = new ObjectMapper();
    private final JsonRestClientConfiguration restConfig;
    private final List<Header> additionalHeaders;
    private String oauthToken;
    private static final CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();

    public JsonRestClient(JsonRestClientConfiguration cfg) {
        this(cfg, null);
    }

    public JsonRestClient(JsonRestClientConfiguration cfg, List<Header> additionalHeaders) {
        this.restConfig = cfg;
        this.additionalHeaders = additionalHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getRequest(String path) throws IOException {
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)get));
            return jsonNode;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestWithOnlyResponseCode(String path) throws IOException {
        CloseableHttpResponse response = null;
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            response = this.handleRequest((HttpRequestBase)get);
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
        finally {
            if (response != null) {
                response.close();
            }
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode deleteRequest(String path) throws IOException {
        HttpDelete del = new HttpDelete(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)del));
            return jsonNode;
        }
        finally {
            del.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode putRequest(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(this.getUrl(path));
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)put));
            return jsonNode;
        }
        finally {
            put.releaseConnection();
        }
    }

    public JsonNode postRequest(String path, JsonNode data) throws IOException {
        String strData = this.mapper.writer().writeValueAsString((Object)data);
        return this.postRequest(path, strData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode postRequest(String path, String data, Map<String, String> headers) throws IOException {
        HttpPost post = new HttpPost(this.getUrl(path));
        if (headers != null) {
            headers.forEach((header, value) -> post.setHeader(header, value));
        }
        if (data != null) {
            post.setEntity((HttpEntity)new StringEntity(data, UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)post));
            return jsonNode;
        }
        finally {
            post.releaseConnection();
        }
    }

    public JsonNode getJwtTokenInfo() throws IOException {
        String[] jwtParts = this.getOauthToken().split("\\.");
        if (jwtParts.length == 3) {
            String base64EncodedBody = jwtParts[1];
            String jwtInfo = new String(Base64.getUrlDecoder().decode(base64EncodedBody));
            try {
                return (JsonNode)this.mapper.readValue(jwtInfo, JsonNode.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse JWT token!");
            }
        }
        throw new IllegalStateException("Failed to parse JWT token!");
    }

    private CloseableHttpResponse handleRequest(HttpRequestBase request) throws IOException {
        this.setAuthHeader((HttpRequest)request);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() == 401) {
            this.authenticate();
            this.setAuthHeader((HttpRequest)request);
            response = client.execute((HttpUriRequest)request);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate() throws IOException {
        logger.info("Authenticating client '{}' with '{}' on '{}'", new Object[]{this.restConfig.getName(), this.restConfig.getGrantType(), this.restConfig.getTokenEndpoint()});
        HttpPost post = new HttpPost(this.restConfig.getTokenEndpoint());
        post.addHeader(CONTENT_TYPE, APP_FORM_ENC);
        if (this.additionalHeaders != null) {
            this.additionalHeaders.forEach(header -> post.addHeader(header));
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair(GRANT_TYPE, this.restConfig.getGrantType()));
        params.add(new BasicNameValuePair(CLIENT_ID, this.restConfig.getClientId()));
        params.add(new BasicNameValuePair(CLIENT_SECRET, this.restConfig.getClientSecret()));
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
            response = client.execute((HttpUriRequest)post);
            this.oauthToken = this.handleJsonResponse(response).get(ACESS_TOKEN).asText().trim();
            logger.debug("Successfully authenticated the client '{}'", (Object)this.restConfig.getName());
        }
        finally {
            if (response != null) {
                response.close();
            }
            post.releaseConnection();
        }
    }

    private void setAuthHeader(HttpRequest request) throws IOException {
        String token = "Bearer " + this.getOauthToken();
        logger.debug("Creating {} request to {} with token '{}'", new Object[]{request.getRequestLine().getMethod(), request.getRequestLine().getUri(), token});
        request.removeHeaders(CONTENT_TYPE);
        request.addHeader(CONTENT_TYPE, JSON_CONTENT);
        request.removeHeaders(AUTHORIZATION);
        request.addHeader(AUTHORIZATION, token);
    }

    private String getOauthToken() throws IOException {
        if (this.oauthToken == null) {
            try {
                this.authenticate();
            }
            catch (IOException e) {
                logger.error("The rest client '{}' could not be authenticated!", (Object)this.restConfig.getName());
                throw e;
            }
        }
        return this.oauthToken;
    }

    private JsonNode handleJsonResponse(CloseableHttpResponse response) throws IOException {
        try {
            int code = response.getStatusLine().getStatusCode();
            logger.debug("Responded with status code '{}'", (Object)code);
            if (code >= 200 && code <= 207) {
                String contentType = JSON_CONTENT;
                if (response.getEntity() != null) {
                    if (response.getEntity().getContentType() != null) {
                        contentType = response.getEntity().getContentType().getValue();
                    }
                    if (contentType.contains(JSON_CONTENT)) {
                        String jsonData = EntityUtils.toString((HttpEntity)response.getEntity());
                        JsonNode jsonNode = (JsonNode)this.mapper.readValue(jsonData, JsonNode.class);
                        return jsonNode;
                    }
                    throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
                }
                JsonNode jsonNode = (JsonNode)this.mapper.readValue("{}", JsonNode.class);
                return jsonNode;
            }
            String reason = response.getStatusLine().getReasonPhrase();
            throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
        }
        finally {
            response.close();
        }
    }

    private String getUrl(String path) {
        return this.restConfig.getApiUrl() + path;
    }
}

