/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.environment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.environment.ServiceBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsEnvironmentVariableReader
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(CdsEnvironmentVariableReader.class);
    private String vcapServices = null;

    public CdsEnvironmentVariableReader(Stream<ServiceBinding> bindings) {
        HashMap serviceToBinding = new HashMap();
        bindings.forEach(binding -> {
            ArrayList<Map<String, Object>> service = (ArrayList<Map<String, Object>>)serviceToBinding.get(binding.getService());
            if (service == null) {
                service = new ArrayList<Map<String, Object>>();
                serviceToBinding.put(binding.getService(), service);
            }
            service.add(this.asMap((ServiceBinding)binding));
        });
        try {
            this.vcapServices = new ObjectMapper().writeValueAsString(serviceToBinding);
        }
        catch (JsonProcessingException e) {
            logger.warn("Could not serialize service bindings to JSON", (Throwable)e);
        }
    }

    private Map<String, Object> asMap(ServiceBinding binding) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", binding.getName());
        map.put("label", binding.getService());
        map.put("plan", binding.getServicePlan());
        map.put("tags", binding.getTags());
        map.put("credentials", binding.getCredentials());
        return map;
    }

    @Override
    public String apply(String name) {
        if (name.equals("VCAP_SERVICES")) {
            return this.vcapServices;
        }
        return System.getenv(name);
    }
}

