/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.environment.ServiceBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VcapServicesParser
implements ServiceBinding {
    public static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final Logger logger = LoggerFactory.getLogger(VcapServicesParser.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private String service;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="binding_name")
    private String bindingName;
    @JsonProperty(value="instance_name")
    private String instanceName;
    @JsonProperty(value="plan")
    private String servicePlan;
    @JsonProperty(value="tags")
    private List<String> tags;
    @JsonProperty(value="credentials")
    private Map<String, Object> credentials;

    public static List<ServiceBinding> getServiceBindings(String vcapServices) {
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        if (vcapServices != null && vcapServices.trim().length() > 0) {
            try {
                JsonNode vcapNodes = mapper.readTree(vcapServices);
                if (vcapNodes.has(VCAP_SERVICES)) {
                    vcapNodes = vcapNodes.get(VCAP_SERVICES);
                }
                vcapNodes.fields().forEachRemaining(serviceField -> {
                    Iterator bindingNodes = ((JsonNode)serviceField.getValue()).elements();
                    int i = 0;
                    while (bindingNodes.hasNext()) {
                        try {
                            VcapServicesParser binding = (VcapServicesParser)mapper.treeToValue((TreeNode)bindingNodes.next(), VcapServicesParser.class);
                            binding.setService((String)serviceField.getKey());
                            bindings.add(binding);
                        }
                        catch (IOException e) {
                            logger.warn("Could not parse service binding of service '{}' at index ''.", new Object[]{serviceField.getKey(), i, e});
                        }
                        ++i;
                    }
                });
            }
            catch (IOException e) {
                logger.warn("Could not parse VCAP_SERVICES", (Throwable)e);
            }
        }
        return bindings;
    }

    public String getName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.bindingName != null && !this.bindingName.isEmpty()) {
            return this.bindingName;
        }
        if (this.instanceName != null && !this.instanceName.isEmpty()) {
            return this.instanceName;
        }
        return "";
    }

    public String getService() {
        return this.service;
    }

    private void setService(String service) {
        this.service = service;
    }

    public String getServicePlan() {
        return this.servicePlan;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }
}

