/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.index;

import com.sap.cds.adapter.IndexContentProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IndexPageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String START = "<!DOCTYPE html>\n    <html>\n        <head>\n            <style>\n                body { margin: 44px; font-family: Avenir Next, sans-serif }\n            </style>\n        </head>\n        <body>\n            <h1> Welcome to <i>cds-services</i> </h1>\n            <p> These are the paths currently served &hellip;\n            <p></p>\n";
    private static final String SECTION_TITLE = "            <br>\n            <h3>%s</h3>\n";
    private static final String END = "            \n        </body>\n    </html>";
    private List<IndexContentProvider> contentProviders;

    public IndexPageServlet(List<IndexContentProvider> contentProviders) {
        this.contentProviders = Collections.unmodifiableList(contentProviders);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.write(START);
        String contextPath = this.getServletConfig() == null ? req.getContextPath() : this.getServletConfig().getServletContext().getContextPath();
        for (IndexContentProvider provider : this.contentProviders) {
            out.format(SECTION_TITLE, provider.getSectionTitle());
            provider.writeContent(out, contextPath);
        }
        out.write(END);
    }
}

