/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.services.messaging.CloudEventMessageEventContext;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CloudEventUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toCloudEvent(String message, String defaultType, String namespace) {
        Map<String, Object> data = CloudEventUtils.toMap(message);
        if (data == null) {
            return message;
        }
        data.computeIfAbsent("id", k -> UUID.randomUUID().toString());
        data.putIfAbsent("specversion", "1.0");
        data.putIfAbsent("datacontenttype", "application/json");
        data.computeIfAbsent("time", k -> Instant.now().toString());
        data.putIfAbsent("type", defaultType);
        data.computeIfAbsent("source", k -> CloudEventUtils.getDefaultSource(namespace));
        return CloudEventUtils.toJson(data);
    }

    private static String getDefaultSource(String namespace) {
        String source = null;
        if (namespace != null) {
            long slashCount;
            String normalizedNamespace = StringUtils.trim(namespace.trim(), '/');
            if (normalizedNamespace.endsWith("/ce")) {
                normalizedNamespace = normalizedNamespace.substring(0, normalizedNamespace.length() - 3);
            }
            if (normalizedNamespace.endsWith("/-")) {
                normalizedNamespace = normalizedNamespace.substring(0, normalizedNamespace.length() - 2);
            }
            if ((slashCount = normalizedNamespace.chars().filter(ch -> ch == 47).count()) == 2L || slashCount == 1L) {
                source = "/" + normalizedNamespace;
            }
        }
        if (source == null) {
            source = "/default/sap.cap/" + CloudEventUtils.getPID();
        }
        return source;
    }

    public static CloudEventMessageEventContext toCloudEventMessageContext(TopicMessageEventContext context, String eventName) {
        CloudEventMessageEventContext ctx = CloudEventMessageEventContext.create((String)eventName);
        Map<String, Object> data = CloudEventUtils.toMap(context.getData());
        if (data == null) {
            throw new ErrorStatusException(CdsErrorStatuses.INVALID_CLOUDEVENTS_MESSAGE, new Object[0]);
        }
        data.entrySet().forEach(e -> {
            if (((String)e.getKey()).equals("time")) {
                ctx.setTime(Instant.parse((String)e.getValue()));
            } else {
                ctx.put((String)e.getKey(), e.getValue());
            }
        });
        return ctx;
    }

    public static String toJson(Map<String, Object> map) {
        return ((CdsData)Struct.access(map).as(CdsData.class)).toJson();
    }

    private static Map<String, Object> toMap(String jsonString) {
        try {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)mapper.readValue(jsonString, (TypeReference)typeRef);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (!StringUtils.isEmpty(processName)) {
            try {
                return Long.parseLong(processName.split("@")[0]);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }
}

