/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.HashMap;
import java.util.Map;

public class MessagingOutboxUtils {
    public static final String OUTBOX_MESSAGING_TARGET = "messaging/";
    private static final JsonMapper mapper = new JsonMapper();
    private static final String DATA = "data";
    private static final String EVENT = "event";

    public static String toOutboxMessage(EventContext context) {
        HashMap data = new HashMap();
        context.keySet().forEach(key -> data.put(key, context.get(key)));
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put(DATA, data);
        message.put(EVENT, context.getEvent());
        try {
            return mapper.writeValueAsString(message);
        }
        catch (Exception e) {
            throw new ErrorStatusException(CdsErrorStatuses.CONTEXT_SERIALIZATION_FAILED, context.getEvent(), e);
        }
    }

    public static EventContext toEventContext(OutboxMessageEventContext outboxContext) {
        Map message;
        try {
            message = (Map)mapper.readValue(outboxContext.getMessage(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new ErrorStatusException(CdsErrorStatuses.CONTEXT_DESERIALIZATION_FAILED, outboxContext.getEvent(), e);
        }
        EventContext context = EventContext.create((String)((String)message.get(EVENT)), null);
        Map data = (Map)message.get(DATA);
        data.forEach((arg_0, arg_1) -> ((EventContext)context).put(arg_0, arg_1));
        return context;
    }
}

