/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.jms;

import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.nio.charset.StandardCharsets;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;

class MessageEmitter {
    private final Session session;
    private final MessageProducer producer;

    MessageEmitter(Connection connection) throws JMSException {
        this.session = connection.createSession();
        this.producer = this.session.createProducer(null);
    }

    public void emitTopicMessage(String topic, String message) {
        try {
            Topic jmsTopic = this.session.createTopic(topic);
            this.producer.send((Destination)jmsTopic, (Message)this.createByteMessage(message));
        }
        catch (JMSException e) {
            throw new ErrorStatusException(CdsErrorStatuses.EVENT_EMITTING_FAILED, new Object[]{topic, e});
        }
    }

    private BytesMessage createByteMessage(String content) throws JMSException {
        BytesMessage msg = this.session.createBytesMessage();
        msg.clearBody();
        msg.writeBytes(content.getBytes(StandardCharsets.UTF_8));
        return msg;
    }
}

