/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CqnUtils {
    private CqnUtils() {
    }

    public static Map<String, Object> convertToIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    public static <S extends CqnStatement> S modifiedWhere(S cqn, Function<Predicate, Predicate> modifyWhere) {
        return (S)CQL.copy(cqn, (Modifier)new WherePredicateModifier(modifyWhere));
    }

    public static Function<Predicate, Predicate> andPredicate(CqnPredicate pred) {
        return new AndPredicate(pred);
    }

    private static class AndPredicate
    implements Function<Predicate, Predicate> {
        private CqnPredicate rhsPred;

        AndPredicate(CqnPredicate rhsPred) {
            this.rhsPred = rhsPred;
        }

        @Override
        public Predicate apply(Predicate lhsPred) {
            return lhsPred != null && this.rhsPred != null ? CQL.and((CqnPredicate)lhsPred, (CqnPredicate)this.rhsPred) : (lhsPred != null ? lhsPred : CQL.copy((CqnPredicate)this.rhsPred));
        }
    }

    private static class WherePredicateModifier
    implements CqnModifier {
        private final Function<Predicate, Predicate> modifyWhere;
        private boolean innerCqn;

        WherePredicateModifier(Function<Predicate, Predicate> modifyWhere) {
            this.modifyWhere = modifyWhere;
        }

        public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
            this.innerCqn = true;
            return super.ref(ref);
        }

        public Predicate where(Predicate pred) {
            if (this.innerCqn) {
                this.innerCqn = false;
                return this.modifyWhere.apply(pred);
            }
            return super.where(pred);
        }
    }
}

