/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.mtx.impl.ClientCredentialJwtReader;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.ModelProviderAccess;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.mtx.impl.SidecarAccessV1;
import com.sap.cds.mtx.impl.SidecarAccessV2;
import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import java.time.Duration;
import java.util.List;

public class DynamicModelUtils {
    private final CdsRuntime runtime;
    private final CdsProperties.Model.Provider providerConfig;
    private final CdsProperties.MultiTenancy.Sidecar sidecarConfig;
    private final XsuaaUtils xsuaaUtils;
    private final boolean mtxs;

    public DynamicModelUtils(CdsRuntime runtime) {
        this.runtime = runtime;
        this.providerConfig = runtime.getEnvironment().getCdsProperties().getModel().getProvider();
        this.sidecarConfig = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSidecar();
        this.mtxs = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getMtxs().isEnabled();
        this.xsuaaUtils = new XsuaaUtils(runtime);
    }

    public boolean useStaticModel() {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        return this.useStaticModel(requestContext.getUserInfo(), requestContext.getFeatureTogglesInfo());
    }

    public boolean useStaticModel(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        boolean hasAllToggles = featureTogglesInfo.getEnabledFeatureToggles().anyMatch(t -> t.getName().trim().equals("*"));
        return userInfo.getTenant() == null && (!this.isModelProviderEnabled() || hasAllToggles);
    }

    public boolean isModelProviderEnabled() {
        return !StringUtils.isEmpty(this.providerConfig.getUrl()) || this.mtxs && !StringUtils.isEmpty(this.sidecarConfig.getUrl());
    }

    private String getModelProviderUrl() {
        return !StringUtils.isEmpty(this.providerConfig.getUrl()) ? this.providerConfig.getUrl() : this.sidecarConfig.getUrl();
    }

    public boolean isClassicSidecarEnabled() {
        return !this.mtxs && !StringUtils.isEmpty(this.sidecarConfig.getUrl());
    }

    public boolean isDynamicModelEnabled() {
        return this.isClassicSidecarEnabled() || this.isModelProviderEnabled();
    }

    public <T> MetaDataAccessor<T> createMetadataAccessor(MetaDataAccessorImpl.EdmxModelCreator<T> modelCreator) {
        ExtensibilityService extService;
        MetaDataAccessor accessor = this.buildMetadataAccessor(modelCreator);
        if (accessor != null && (extService = (ExtensibilityService)this.runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default")) != null) {
            extService.on("MODEL_CHANGED", null, context -> accessor.refresh(context.getUserInfo().getTenant()));
        }
        return accessor;
    }

    private <T> MetaDataAccessor<T> buildMetadataAccessor(MetaDataAccessorImpl.EdmxModelCreator<T> modelCreator) {
        ClientCredentialJwtReader jwtReader = this.createClientCredentialJwtReader();
        Object authenticator = jwtReader == null ? Authenticator.NONE : new ClientCredentialJwtAccess(jwtReader);
        ModelProviderAccess sidecarAccess = null;
        CacheParams cacheParams = null;
        if (this.isModelProviderEnabled()) {
            sidecarAccess = new ModelProviderAccess(this.getModelProviderUrl(), authenticator, this.getResilienceConfig());
            cacheParams = this.getCacheParams(this.providerConfig.getCache());
        } else if (this.isClassicSidecarEnabled()) {
            cacheParams = this.getCacheParams(this.sidecarConfig.getCache());
            switch (this.sidecarConfig.getVersion()) {
                case 1: {
                    sidecarAccess = new SidecarAccessV1(this.sidecarConfig.getUrl(), authenticator, this.getResilienceConfig());
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Classic MTX Sidecar supports only versions 1 and 2");
                }
                default: {
                    sidecarAccess = new SidecarAccessV2(this.sidecarConfig.getUrl(), authenticator, this.getResilienceConfig());
                }
            }
        }
        if (sidecarAccess != null && cacheParams != null) {
            return new MetaDataAccessorImpl((SidecarAccess)sidecarAccess, cacheParams, modelCreator, null);
        }
        return null;
    }

    private CacheParams getCacheParams(CdsProperties.MultiTenancy.Sidecar.Cache cache) {
        long maximumSize = cache.getMaxSize();
        long expirationDuration = cache.getExpirationTime();
        long refreshDuration = cache.getRefreshTime();
        return new CacheParams(maximumSize, Duration.ofSeconds(expirationDuration), Duration.ofSeconds(refreshDuration), false);
    }

    public ClientCredentialJwtReader createClientCredentialJwtReader() {
        List<ServiceBinding> uaaBindings = this.xsuaaUtils.getXsuaaServiceBindings();
        if (!uaaBindings.isEmpty()) {
            ServiceBinding uaaInstance = uaaBindings.get(0);
            return new ClientCredentialJwtReader(new XsuaaParams(uaaInstance.getCredentials()));
        }
        return null;
    }

    public ResilienceConfig getResilienceConfig() {
        return ResilienceConfig.builder().numOfRetries(3).retryInterval(Duration.ofMillis(500L)).build();
    }
}

