/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.cds.services.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Privilege {
    @JsonProperty(value="grant")
    private List<String> grants = new ArrayList<String>();
    @JsonProperty(value="to")
    private List<String> roles = new ArrayList<String>();
    @JsonProperty(value="where")
    private String whereCondition;
    @JsonProperty(value="_where")
    private String cxnWhereCondition;

    public List<String> getGrants() {
        return Collections.unmodifiableList(this.grants);
    }

    public Privilege addGrant(PredefinedGrant grant) {
        return this.addGrant(grant.toString());
    }

    public Privilege addGrant(String grant) {
        Objects.requireNonNull(StringUtils.notEmpty(grant));
        this.grants.add(grant.trim());
        return this;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public Privilege addRole(PredefinedRole role) {
        return this.addRole(role.toString());
    }

    public Privilege addRole(String role) {
        Objects.requireNonNull(StringUtils.notEmpty(role));
        this.roles.add(role.trim());
        return this;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public String getCxnWhereCondition() {
        return this.cxnWhereCondition;
    }

    public void setCxnWhereCondition(String cxnWhereCondition) {
        this.cxnWhereCondition = cxnWhereCondition;
    }

    public static boolean is(String a, String b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public static enum PredefinedRole {
        ANY_USER("any"),
        AUTHENTICATED_USER("authenticated-user"),
        SYSTEM_USER("system-user"),
        INTERNAL_USER("internal-user");

        private final String role;

        private PredefinedRole(String role) {
            this.role = role;
        }

        public boolean is(String role) {
            return Privilege.is(this.role, role);
        }

        public String toString() {
            return this.role;
        }
    }

    public static enum PredefinedGrant {
        ALL("*"),
        WRITE("WRITE");

        private final String grant;

        private PredefinedGrant(String grant) {
            this.grant = grant;
        }

        public boolean is(String grant) {
            return Privilege.is(this.grant, grant);
        }

        public String toString() {
            return this.grant;
        }
    }
}

