/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.rest.client.JsonRestClientConfiguration;
import com.sap.cds.services.utils.rest.client.JsonRestClientResponseException;
import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.mtls.SSLContextFactory;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(JsonRestClient.class);
    private static final String UTF_8 = "UTF-8";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer";
    private static final String JSON_CONTENT = "application/json";
    private static final String CONTENT_TYPE = "content-type";
    protected final ObjectMapper mapper = new ObjectMapper();
    private JsonRestClientConfiguration restConfig;
    private XsuaaTokenFlows xsUaaTokenFlows;
    private OAuthToken oauthToken;
    private final CloseableHttpClient client;

    public JsonRestClient(JsonRestClientConfiguration cfg, Map<String, Object> cedentials) {
        this(cfg, cedentials, 20, 2);
    }

    public JsonRestClient(JsonRestClientConfiguration cfg, Map<String, Object> cedentials, int maxConnections, int maxConnectionPerRoute) {
        this.restConfig = cfg;
        XsuaaParams xsuaaParams = new XsuaaParams(cedentials);
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = xsuaaParams.getOAuth2ServiceConfiguration();
        this.client = this.createClient(oAuth2ServiceConfiguration.getClientIdentity(), maxConnections, maxConnectionPerRoute);
        this.xsUaaTokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService(this.client), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(oAuth2ServiceConfiguration), oAuth2ServiceConfiguration.getClientIdentity());
    }

    private CloseableHttpClient createClient(ClientIdentity clientIdentity, int maxConnections, int maxConnectionPerRoute) throws HttpClientException {
        if (clientIdentity != null && clientIdentity.isCertificateBased()) {
            SSLContext sslContext;
            logger.debug("Setting up HTTPS client with '{}' total pooled connections, '{}' connections per route and certificate: \n{}\n", new Object[]{maxConnections, maxConnectionPerRoute, clientIdentity.getCertificate()});
            try {
                sslContext = SSLContextFactory.getInstance().create(clientIdentity);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientException(String.format("Couldn't set up https client for service provider. %s.", e.getLocalizedMessage()));
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLContext(sslContext).setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setMaxConnTotal(maxConnections).setMaxConnPerRoute(maxConnectionPerRoute).build();
        }
        logger.debug("Setting up default http client with total pooled connections '{}' and '{}' connections per route", (Object)maxConnections, (Object)maxConnectionPerRoute);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnectionPerRoute);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getRequest(String path) throws IOException {
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)get));
            return jsonNode;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * Loose catch block
     */
    public int getRequestWithOnlyResponseCode(String path) throws IOException {
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            try (CloseableHttpResponse response = this.handleRequest((HttpRequestBase)get);){
                int n = response.getStatusLine().getStatusCode();
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode deleteRequest(String path) throws IOException {
        HttpDelete del = new HttpDelete(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)del));
            return jsonNode;
        }
        finally {
            del.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode putRequest(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(this.getUrl(path));
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)put));
            return jsonNode;
        }
        finally {
            put.releaseConnection();
        }
    }

    public JsonNode postRequest(String path, JsonNode data) throws IOException {
        String strData = this.mapper.writer().writeValueAsString((Object)data);
        return this.postRequest(path, strData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode postRequest(String path, String data, Map<String, String> headers) throws IOException {
        HttpPost post = new HttpPost(this.getUrl(path));
        if (headers != null) {
            headers.forEach((header, value) -> post.setHeader(header, value));
        }
        if (data != null) {
            post.setEntity((HttpEntity)new StringEntity(data, UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)post));
            return jsonNode;
        }
        finally {
            post.releaseConnection();
        }
    }

    public JsonNode getJwtTokenInfo() throws IOException {
        String[] jwtParts = this.getAccessToken().split("\\.");
        if (jwtParts.length == 3) {
            String base64EncodedBody = jwtParts[1];
            String jwtInfo = new String(Base64.getUrlDecoder().decode(base64EncodedBody));
            try {
                return (JsonNode)this.mapper.readValue(jwtInfo, JsonNode.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse JWT token!");
            }
        }
        throw new IllegalStateException("Failed to parse JWT token!");
    }

    private CloseableHttpResponse handleRequest(HttpRequestBase request) throws IOException {
        this.setAuthHeader((HttpRequest)request);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() == 401) {
            this.authenticate();
            this.setAuthHeader((HttpRequest)request);
            response = this.client.execute((HttpUriRequest)request);
        }
        return response;
    }

    private void authenticate() throws IOException {
        String tenant = this.restConfig.getCurrentTenant();
        logger.debug("Authenticating client '{}' on '{}'{}", new Object[]{this.restConfig.getName(), this.restConfig.getApiUrl(), StringUtils.isEmpty(tenant) ? "" : " for tenant '" + tenant + "'"});
        OAuth2TokenResponse response = tenant != null ? this.xsUaaTokenFlows.clientCredentialsTokenFlow().zoneId(tenant).execute() : this.xsUaaTokenFlows.clientCredentialsTokenFlow().execute();
        this.oauthToken = new OAuthToken(response.getExpiredAt(), response.getAccessToken());
    }

    private void setAuthHeader(HttpRequest request) throws IOException {
        String token = "Bearer " + this.getAccessToken();
        logger.debug("Creating {} request to {} with oauth token", (Object)request.getRequestLine().getMethod(), (Object)request.getRequestLine().getUri());
        request.removeHeaders(CONTENT_TYPE);
        request.addHeader(CONTENT_TYPE, JSON_CONTENT);
        request.removeHeaders(AUTHORIZATION);
        request.addHeader(AUTHORIZATION, token);
    }

    private String getAccessToken() throws IOException {
        if (this.oauthToken == null || !this.oauthToken.isValid()) {
            try {
                this.authenticate();
            }
            catch (IOException e) {
                if (e.getCause() instanceof OAuth2ServiceException) {
                    OAuth2ServiceException oauthExc = (OAuth2ServiceException)e.getCause();
                    throw new JsonRestClientResponseException(oauthExc.getHttpStatusCode(), "Unexpected request HTTP response (" + oauthExc.getHttpStatusCode() + ") " + oauthExc.getMessage(), e);
                }
                logger.error("The rest client '{}' could not be authenticated!", (Object)this.restConfig.getName());
                throw e;
            }
        }
        return this.oauthToken.getAccessToken();
    }

    private JsonNode handleJsonResponse(CloseableHttpResponse response) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse resp = response;){
            int code = resp.getStatusLine().getStatusCode();
            logger.debug("Responded with status code '{}'", (Object)code);
            if (code >= 200 && code <= 207) {
                String contentType = JSON_CONTENT;
                if (resp.getEntity() != null) {
                    if (resp.getEntity().getContentType() != null) {
                        contentType = resp.getEntity().getContentType().getValue();
                    }
                    if (contentType.contains(JSON_CONTENT)) {
                        String jsonData = EntityUtils.toString((HttpEntity)resp.getEntity());
                        JsonNode jsonNode = (JsonNode)this.mapper.readValue(jsonData, JsonNode.class);
                        return jsonNode;
                    }
                    throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
                }
                JsonNode jsonNode = (JsonNode)this.mapper.readValue("{}", JsonNode.class);
                return jsonNode;
            }
            try {
                String reason = resp.getStatusLine().getReasonPhrase();
                throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String getUrl(String path) {
        return this.restConfig.getApiUrl() + path;
    }

    public static class OAuthToken {
        private final Instant expiredIn;
        private final String accessToken;

        public OAuthToken(Instant expiredIn, String accessToken) {
            this.expiredIn = expiredIn;
            this.accessToken = accessToken;
        }

        public boolean isValid() {
            return Instant.now().isBefore(this.expiredIn);
        }

        public String getAccessToken() {
            return this.accessToken;
        }
    }
}

