/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.CdsErrorStatuses;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.helpers.MessageFormatter;

public class ErrorStatusException
extends ServiceException {
    private static final long serialVersionUID = 1L;

    public ErrorStatusException(ErrorStatus errorStatus, Object ... args) {
        super(errorStatus, errorStatus.getCodeString(), args);
    }

    public String getMessage() {
        return this.getDefaultErrorStatusDescription();
    }

    public String getLocalizedMessage(Locale locale) {
        String localized = super.getLocalizedMessage(locale);
        if (Objects.equals(localized, this.getPlainMessage())) {
            boolean stackMessages = Utils.getErrorsProperties().getStackMessages().isEnabled();
            if (this.errorStatus instanceof CdsErrorStatuses && !stackMessages) {
                return new ErrorStatusException(((CdsErrorStatuses)this.errorStatus).getHttpError(), new Object[0]).getLocalizedMessage(locale);
            }
            if (!(this.errorStatus instanceof ErrorStatuses) && !stackMessages) {
                return new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale);
            }
            return this.getDefaultErrorStatusDescription();
        }
        return localized;
    }

    private String getDefaultErrorStatusDescription() {
        return MessageFormatter.arrayFormat((String)this.getErrorStatus().getDescription(), (Object[])this.args).getMessage();
    }
}

