/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.SessionContext;
import com.sap.cds.UserContext;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import java.time.Instant;

public class SessionContextUtils {
    private SessionContextUtils() {
    }

    public static SessionContext toSessionContext(EventContext context) {
        return SessionContextUtils.toSessionContext(context.getUserInfo(), context.getParameterInfo());
    }

    public static SessionContext toSessionContext(RequestContext context) {
        return SessionContextUtils.toSessionContext(context.getUserInfo(), context.getParameterInfo());
    }

    private static SessionContext toSessionContext(UserInfo userInfo, ParameterInfo parameterInfo) {
        return SessionContext.create().setUserContext(SessionContextUtils.toUserContext(userInfo, parameterInfo)).setValidFrom(parameterInfo.getValidFrom()).setValidTo(parameterInfo.getValidTo()).setNow(Instant.now());
    }

    private static UserContext toUserContext(UserInfo userInfo, ParameterInfo parameterInfo) {
        return UserContext.create().setId(userInfo.getName()).setLocale(parameterInfo.getLocale()).setTenant(userInfo.getTenant()).setAttributes(userInfo.getAttributes());
    }
}

