/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class XsuaaUtils {
    private static final String XSUAA = "xsuaa";
    private static final String IDENTITY = "identity";
    private final CdsRuntime runtime;

    public XsuaaUtils(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public List<ServiceBinding> getXsuaaServiceBindings() {
        Stream<ServiceBinding> xsuaaBindings = this.runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches(b, XSUAA, XSUAA));
        String xsuaaServiceBinding = this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().getBinding();
        if (!StringUtils.isEmpty(xsuaaServiceBinding)) {
            xsuaaBindings = xsuaaBindings.filter(b -> xsuaaServiceBinding.equalsIgnoreCase((String)b.getName().get()));
        }
        return xsuaaBindings.collect(Collectors.toList());
    }

    public List<ServiceBinding> getIasServiceBindings() {
        Stream<ServiceBinding> iasBindings = this.runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches(b, IDENTITY, IDENTITY));
        return iasBindings.collect(Collectors.toList());
    }

    public AuthenticationType configuredAuthenticationType() {
        boolean iasBindings;
        boolean xsuaaBindings = !this.getXsuaaServiceBindings().isEmpty();
        boolean bl = iasBindings = !this.getIasServiceBindings().isEmpty();
        if (xsuaaBindings) {
            return iasBindings ? AuthenticationType.IAS_XSUAA : AuthenticationType.XSUAA;
        }
        if (iasBindings) {
            return AuthenticationType.IAS;
        }
        return null;
    }

    public boolean xsuaaAuthenticationConfigured() {
        if (!this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isEnabled().booleanValue()) {
            return false;
        }
        AuthenticationType authType = this.configuredAuthenticationType();
        return authType == AuthenticationType.XSUAA;
    }

    public boolean identityAuthenticationConfigured() {
        if (!this.runtime.getEnvironment().getCdsProperties().getSecurity().getIdentity().isEnabled().booleanValue()) {
            return false;
        }
        AuthenticationType authType = this.configuredAuthenticationType();
        return authType == AuthenticationType.IAS || authType == AuthenticationType.IAS_XSUAA;
    }

    public static enum AuthenticationType {
        XSUAA,
        IAS_XSUAA,
        IAS;

    }
}

