/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum CdsAnnotations {
    RESTRICT(null, "restrict"),
    REQUIRES(null, "requires"),
    READONLY(false, "readonly"),
    INSERTONLY(false, "insertonly"),
    INSERTABLE(true, "Capabilities.Insertable", "Capabilities.InsertRestrictions.Insertable"),
    UPDATABLE(true, "Capabilities.Updatable", "Capabilities.UpdateRestrictions.Updatable"),
    DELETABLE(true, "Capabilities.Deletable", "Capabilities.DeleteRestrictions.Deletable"),
    READABLE(true, "Capabilities.Readable", "Capabilities.ReadRestrictions.Readable"),
    UPDATABLE_DELTA(false, "Capabilities.UpdateRestrictions.DeltaUpdateSupported"),
    AUTOEXPOSED(false, "cds.autoexposed"),
    AUTOEXPOSE(false, "cds.autoexpose"),
    ON_INSERT(null, "cds.on.insert", "odata.on.insert"),
    ON_UPDATE(null, "cds.on.update", "odata.on.update"),
    MANDATORY(false, "mandatory", "Common.FieldControl.Mandatory", "FieldControl.Mandatory"),
    FIELD_CONTROL_READONLY(false, "Common.FieldControl.ReadOnly", "FieldControl.ReadOnly"),
    COMMON_FIELDCONTROL(null, "Common.FieldControl"),
    ASSERT_RANGE(false, "assert.range"),
    ASSERT_FORMAT(false, "assert.format"),
    ASSERT_NOTNULL(true, "assert.notNull"),
    ASSERT_TARGET(false, "assert.target"),
    QUERY_LIMIT_DEFAULT(null, "cds.query.limit.default", "cds.query.limit"),
    QUERY_LIMIT_MAX(null, "cds.query.limit.max"),
    DEFAULT_ORDER(null, "cds.default.order", "odata.default.order"),
    CORE_COMPUTED(false, "Core.Computed"),
    CORE_IMMUTABLE(false, "Core.Immutable"),
    CORE_MEDIA_TYPE(null, "Core.MediaType"),
    CORE_CONTENT_DISPOSITION_FILENAME(null, "Core.ContentDisposition.Filename"),
    SINGLETON(false, "odata.singleton"),
    DRAFT_ANNOTATION(false, "odata.draft.enabled"),
    DRAFT_PREPARE_ANNOTATION(null, "Common.DraftNode.PreparationAction"),
    ODATA_FOREIGN_KEY_FOR(null, "odata.foreignKey4"),
    PATH(null, "endpoints.path", "path"),
    PROTOCOLS(null, "endpoints.protocol", "protocols", "protocol"),
    ENDPOINTS(null, "endpoints"),
    IGNORE(false, "cds.ignore"),
    SERVE_IGNORE(false, "cds.serve.ignore"),
    TOPIC(null, "topic"),
    KAFKA_TOPIC(null, "kafka.topic"),
    ETAG(false, "odata.etag"),
    AGGREGATION_DEFAULT(null, "Aggregation.default"),
    SEMANTICS_CURRENCY_CODE(false, "Semantics.currencyCode"),
    SEMANTICS_UNIT_OF_MEASURE(false, "Semantics.unitOfMeasure"),
    PERSONALDATA_ENTITYSEMANTICS(null, "PersonalData.EntitySemantics"),
    PERSONALDATA_DATASUBJECTROLE(null, "PersonalData.DataSubjectRole"),
    PERSONALDATA_FIELDSEMANTICS(null, "PersonalData.FieldSemantics"),
    PERSONALDATA_POTENTIALLYPERSONAL(null, "PersonalData.IsPotentiallyPersonal"),
    PERSONALDATA_POTENTIALLYSENSITIVE(null, "PersonalData.IsPotentiallySensitive"),
    AUDITLOG_OPERATION_READ(false, "AuditLog.Operation.Read"),
    AUDITLOG_OPERATION_INSERT(false, "AuditLog.Operation.Insert"),
    AUDITLOG_OPERATION_UPDATE(false, "AuditLog.Operation.Update"),
    AUDITLOG_OPERATION_DELETE(false, "AuditLog.Operation.Delete"),
    CASCADE_DELETE(null, "cascade.delete"),
    INTERNAL_OPERATION_TYPE(false, "cds.internal.operationType");

    private final String[] names;
    private final Object defaultValue;

    private CdsAnnotations(Object defaultValue, String ... names) {
        this.defaultValue = defaultValue;
        this.names = names;
    }

    public <T> T getOrDefault(CdsAnnotatable cdsModelElement) {
        return (T)this.getOrValue(cdsModelElement, this.defaultValue);
    }

    public boolean isTrue(CdsAnnotatable cdsModelElement) {
        return Boolean.TRUE.equals(this.getOrDefault(cdsModelElement));
    }

    public <T> List<T> getListOrDefault(CdsAnnotatable cdsModelElement) {
        return this.getListOrValue(cdsModelElement, this.defaultValue);
    }

    public <T> List<T> getListOrValue(CdsAnnotatable cdsModelElement, T value) {
        T annotationValue = this.getOrValue(cdsModelElement, value);
        if (annotationValue != null) {
            if (annotationValue instanceof List) {
                return (List)annotationValue;
            }
            return Arrays.asList(annotationValue);
        }
        return null;
    }

    public <T> T getOrValue(CdsAnnotatable cdsModelElement, T value) {
        for (String name : this.names) {
            Optional annotation = cdsModelElement.findAnnotation(name);
            if (!annotation.isPresent()) continue;
            Object annotationValue = ((CdsAnnotation)annotation.get()).getValue();
            if (annotationValue != null && !annotationValue.equals(value)) {
                return (T)annotationValue;
            }
            if (annotationValue != null || value == null) continue;
            return (T)annotationValue;
        }
        return value;
    }
}

