/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.outbox;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.utils.StringUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractOutboxService
extends ServiceDelegator
implements OutboxService {
    private final Set<String> eventsWithOnHandler = ConcurrentHashMap.newKeySet();

    public AbstractOutboxService(String name) {
        super(name);
    }

    public void enroll(String targetEvent, String message) {
        OutboxMessageEventContext context = OutboxMessageEventContext.create((String)targetEvent);
        context.setMessage(message);
        this.emit((EventContext)context);
    }

    @On
    @HandlerOrder(value=-9900)
    private void handleOutboxEvent(OutboxMessageEventContext context) {
        if (Boolean.FALSE.equals(context.getIsInbound())) {
            if (context.getTimestamp() == null) {
                context.setTimestamp(Instant.now());
            }
            this.enroll(context);
            context.setCompleted();
        }
    }

    @On
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoComplete(EventContext context) {
        if (this.eventsWithOnHandler.contains(context.getEvent())) {
            context.setCompleted();
        }
    }

    public void on(String[] events, String[] entities, int order, Handler handler) {
        super.on(events, entities, order, handler);
        Arrays.stream(events).filter(event -> !StringUtils.isEmpty(event) && !event.equals("*")).forEach(this.eventsWithOnHandler::add);
    }

    protected abstract void enroll(OutboxMessageEventContext var1);
}

