/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.runtime;

import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.TemporalRangeUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class HttpParameterInfo
implements ParameterInfo {
    private final Map<String, String[]> parameters;
    private final Map<String, String> headers;
    private final String correlationId;
    private final Locale locale;
    private final Instant validFrom;
    private final Instant validTo;

    private HttpParameterInfo(HttpServletRequest httpRequest, LocaleUtils localeUtils) {
        this.parameters = new HashMap<String, String[]>(httpRequest.getParameterMap());
        this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration headerKeys = httpRequest.getHeaderNames();
        if (headerKeys != null) {
            while (headerKeys.hasMoreElements()) {
                String headerKey = (String)headerKeys.nextElement();
                Enumeration headerValues = httpRequest.getHeaders(headerKey);
                String headerValue = null;
                if (headerValues != null && headerValues.hasMoreElements()) {
                    headerValue = Collections.list(headerValues).stream().collect(Collectors.joining(","));
                }
                this.headers.put(headerKey, headerValue);
            }
        }
        this.correlationId = CorrelationIdUtils.getOrGenerateCorrelationId(this);
        this.locale = localeUtils.getLocale(this.getQueryParameter("sap-locale"), this.getHeader("Accept-Language"), this.getQueryParameter("sap-language"), this.getHeader("x-sap-request-language"));
        Instant[] ranges = TemporalRangeUtils.getTemporalRanges(this.getQueryParameter("sap-valid-from"), this.getQueryParameter("sap-valid-to"), this.getQueryParameter("sap-valid-at"));
        this.validFrom = ranges[0];
        this.validTo = ranges[1];
    }

    public static ParameterInfo fromRequest(HttpServletRequest httpRequest, CdsRuntime runtime) {
        return new HttpParameterInfo(httpRequest, new LocaleUtils(runtime.getEnvironment().getCdsProperties()));
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getHeader(String id) {
        return this.headers.get(id);
    }

    public String getQueryParameter(String key) {
        String[] values = this.parameters.get(key);
        if (values != null && values.length >= 1) {
            return values[0];
        }
        return null;
    }

    public Map<String, String> getQueryParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
            String[] values = entry.getValue();
            String valueString = values != null ? Arrays.asList(values).stream().collect(Collectors.joining(",")) : null;
            result.put(entry.getKey(), valueString);
        }
        return result;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Instant getValidTo() {
        return this.validTo;
    }
}

