/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DraftUtils {
    private static final Logger log = LoggerFactory.getLogger(DraftUtils.class);

    private DraftUtils() {
    }

    public static boolean isDraftEnabled(String serviceName, CdsModel model) {
        return model.findService(serviceName).map(s -> s.entities().anyMatch(e -> DraftUtils.isDraftEnabled((CdsAnnotatable)e))).orElse(false);
    }

    public static boolean isDraftTarget(CqnStructuredTypeRef ref, CdsEntity entity, CdsModel model) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)entity)) {
            Iterator segments = CqnAnalyzer.create((CdsModel)model).analyze(ref).reverse();
            while (segments.hasNext()) {
                Map targetKeys = ((ResolvedSegment)segments.next()).keyValues();
                if (targetKeys.isEmpty()) continue;
                return targetKeys.containsKey("IsActiveEntity") && Boolean.FALSE.equals(targetKeys.get("IsActiveEntity"));
            }
        }
        return false;
    }

    public static boolean isDraftEnabled(CdsAnnotatable entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue(entity) || CdsAnnotations.DRAFT_PREPARE_ANNOTATION.getOrDefault(entity) != null;
    }

    public static boolean isDraftRoot(CdsAnnotatable entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue(entity);
    }

    public static void gcDraftsOfAllServices(CdsRuntime runtime) {
        Stream draftServices = runtime.getServiceCatalog().getServices(DraftService.class);
        draftServices.forEach(DraftService::gcDrafts);
    }

    public static void gcDraftsOfAllServicesAndTenants(CdsRuntime runtime) {
        TenantProviderService tenantProvider = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        List tenants = tenantProvider.readTenants();
        tenants.forEach(tenant -> {
            try {
                runtime.requestContext().privilegedUser().modifyUser(user -> user.setTenant(tenant)).run(context -> DraftUtils.gcDraftsOfAllServices(runtime));
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof CdsCommunicationException && ((CdsCommunicationException)rootCause).getHttpStatusCode() == 404) {
                    log.debug("Skipped draft GC for nonexistent tenant '{}'", tenant);
                }
                log.error("Failed to gc drafts of tenant '{}'", tenant, (Object)e);
            }
        });
    }
}

