/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.UpdateBuilder;
import java.util.HashMap;
import java.util.Map;

public class CqnUtils {
    private CqnUtils() {
    }

    public static Map<String, Object> convertToIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    public static <S extends CqnStatement> S addWhere(S cqn, CqnPredicate pred) {
        if (pred == null || pred == CqnBoolLiteral.TRUE) {
            return cqn;
        }
        if (cqn.isSelect()) {
            SelectBuilder s = (SelectBuilder)cqn;
            return (S)SelectBuilder.copyShallow((CqnSelect)s).filterSource(pred);
        }
        if (cqn.isUpdate()) {
            UpdateBuilder u = (UpdateBuilder)cqn;
            return (S)UpdateBuilder.copyShallow((CqnUpdate)u).filter(pred);
        }
        if (cqn.isDelete()) {
            DeleteBuilder d = (DeleteBuilder)cqn;
            return (S)DeleteBuilder.copyShallow((CqnDelete)d).filter(pred);
        }
        throw new IllegalStateException("Unexpected statement type: " + cqn.getClass().getCanonicalName());
    }

    public static Delete<?> toDelete(CqnSelect s) {
        Delete delete = Delete.from((CqnStructuredTypeRef)s.ref());
        s.where().ifPresent(arg_0 -> ((Delete)delete).where(arg_0));
        return delete;
    }

    public static Select<?> toSelect(CqnDelete delete) {
        Select select = Select.from((CqnStructuredTypeRef)delete.ref());
        delete.where().ifPresent(arg_0 -> ((Select)select).where(arg_0));
        return select;
    }
}

