/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.outbox;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

public class OutboxUtils {
    public static final String OUTBOX_MODEL = "cds.outbox.Messages";

    public static boolean hasOutboxModel(CdsModel model) {
        return model.findEntity(OUTBOX_MODEL).isPresent();
    }

    public static OutboxService chooseOutboxService(CdsRuntime runtime, boolean allowPersistentOutbox) {
        OutboxService result;
        RequestContext context = RequestContext.getCurrent((CdsRuntime)runtime);
        OutboxService inMemoryOutbox = (OutboxService)context.getServiceCatalog().getService(OutboxService.class, "OutboxService$InMemory");
        OutboxService persistentOutbox = (OutboxService)context.getServiceCatalog().getService(OutboxService.class, "OutboxService$Persistent");
        boolean providerTenantPersistence = runtime.getEnvironment().getCdsProperties().getOutbox().getPersistent().getProviderTenant().isEnabled();
        Object object = result = allowPersistentOutbox ? persistentOutbox : null;
        if (result == null || !providerTenantPersistence && context.getUserInfo().getTenant() == null || !OutboxUtils.hasOutboxModel(context.getModel())) {
            result = inMemoryOutbox;
        }
        return result;
    }
}

