/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.environment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsEnvironmentVariableReader
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(CdsEnvironmentVariableReader.class);
    private String vcapServices = null;

    public CdsEnvironmentVariableReader(Stream<ServiceBinding> bindings) {
        HashMap serviceToBinding = new HashMap();
        bindings.forEach(binding -> {
            ArrayList<Map<String, Object>> service = (ArrayList<Map<String, Object>>)serviceToBinding.get(binding.getServiceName().get());
            if (service == null) {
                service = new ArrayList<Map<String, Object>>();
                serviceToBinding.put((String)binding.getServiceName().get(), service);
            }
            service.add(this.asMap((ServiceBinding)binding));
        });
        try {
            this.vcapServices = new ObjectMapper().writeValueAsString(serviceToBinding);
        }
        catch (JsonProcessingException e) {
            logger.warn("Could not serialize service bindings to JSON", (Throwable)e);
        }
    }

    private Map<String, Object> asMap(ServiceBinding binding) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", binding.getName().get());
        map.put("label", binding.getServiceName().get());
        map.put("plan", binding.getServicePlan().orElse(null));
        map.put("tags", binding.getTags());
        map.put("credentials", binding.getCredentials());
        return map;
    }

    @Override
    public String apply(String name) {
        if (name.equals("VCAP_SERVICES")) {
            return this.vcapServices;
        }
        return System.getenv(name);
    }
}

