/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String notEmpty(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (StringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String trim(String value, char c) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == c; ++st) {
        }
        while (st < len && val[len - 1] == c) {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static boolean equalsMapIgnoreCase(Map<String, String> props, Map<String, String> otherProps) {
        if (props == null && otherProps == null) {
            return true;
        }
        if (props == null || otherProps == null || props.size() != otherProps.size()) {
            return false;
        }
        for (Map.Entry<String, String> prop : props.entrySet()) {
            if (StringUtils.findEqualsKeyValue(prop.getKey(), prop.getValue(), otherProps)) continue;
            return false;
        }
        return true;
    }

    private static boolean findEqualsKeyValue(String key, String value, Map<String, String> props) {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            if (key != prop.getKey() && (key == null || !key.equalsIgnoreCase(prop.getKey())) || !Objects.equals(value, prop.getValue())) continue;
            return true;
        }
        return false;
    }

    public static String stringifyMap(Map<String, Object> keyValueMap) {
        return keyValueMap.entrySet().stream().map(k -> (String)k.getKey() + "=" + k.getValue()).collect(Collectors.joining(", "));
    }

    public static String stringifyList(List<String> values) {
        return values.stream().collect(Collectors.joining(", "));
    }

    public static String toStringSafely(Object[] args) {
        if (args != null) {
            StringBuffer sb = new StringBuffer();
            for (Object arg : args) {
                sb.append('<');
                try {
                    if (arg != null) {
                        sb.append(arg.toString());
                    } else {
                        sb.append("null");
                    }
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
                sb.append('>');
            }
            return sb.toString();
        }
        return "<null>";
    }
}

