/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.ModelProviderAccess;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.mtx.impl.SidecarAccessV1;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cds.services.utils.destination.XsuaaOAuth2PropertySupplier;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import io.vavr.control.Option;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelUtils {
    private static final Logger logger;
    private final CdsRuntime runtime;
    private final CdsProperties.Model.Provider providerConfig;
    private final CdsProperties.MultiTenancy.Sidecar sidecarConfig;
    private final XsuaaUtils xsuaaUtils;
    private final boolean mtxs;

    public DynamicModelUtils(CdsRuntime runtime) {
        this.runtime = runtime;
        this.providerConfig = runtime.getEnvironment().getCdsProperties().getModel().getProvider();
        this.sidecarConfig = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSidecar();
        this.mtxs = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getMtxs().isEnabled();
        this.xsuaaUtils = new XsuaaUtils(runtime);
    }

    public boolean useStaticModel() {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        return this.useStaticModel(requestContext.getUserInfo(), requestContext.getFeatureTogglesInfo());
    }

    public boolean useStaticModel(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        boolean hasAllToggles = featureTogglesInfo.getEnabledFeatureToggles().anyMatch(t -> t.getName().trim().equals("*"));
        return userInfo.getTenant() == null && (!this.isModelProviderEnabled() || hasAllToggles);
    }

    public boolean isModelProviderEnabled() {
        return !StringUtils.isEmpty(this.providerConfig.getUrl()) || this.mtxs && !StringUtils.isEmpty(this.sidecarConfig.getUrl());
    }

    public String getModelProviderUrl() {
        return !StringUtils.isEmpty(this.providerConfig.getUrl()) ? this.providerConfig.getUrl() : this.sidecarConfig.getUrl();
    }

    public boolean isClassicSidecarEnabled() {
        return !this.mtxs && !StringUtils.isEmpty(this.sidecarConfig.getUrl());
    }

    public boolean isDynamicModelEnabled() {
        return this.isClassicSidecarEnabled() || this.isModelProviderEnabled();
    }

    public <T> MetaDataAccessor<T> createMetadataAccessor(MetaDataAccessorImpl.EdmxModelCreator<T> strToEdmx, MetaDataAccessorImpl.CdsModelCreator strToModel, MetaDataAccessorImpl.I18nResourceCreator strToI18n) {
        ExtensibilityService extService;
        MetaDataAccessor accessor = this.buildMetadataAccessor(strToEdmx, strToModel, strToI18n);
        if (accessor != null && (extService = (ExtensibilityService)this.runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default")) != null) {
            extService.on("MODEL_CHANGED", null, context -> {
                String tenant = context.getUserInfo().getTenant();
                if (this.sidecarConfig.getCache().isRefreshEager()) {
                    accessor.refresh(tenant);
                } else {
                    accessor.evict(tenant);
                }
            });
        }
        return accessor;
    }

    private <T> MetaDataAccessor<T> buildMetadataAccessor(MetaDataAccessorImpl.EdmxModelCreator<T> strToEdmx, MetaDataAccessorImpl.CdsModelCreator strToModel, MetaDataAccessorImpl.I18nResourceCreator strToI18n) {
        ModelProviderAccess sidecarAccess = null;
        CacheParams cacheParams = null;
        if (this.isModelProviderEnabled()) {
            sidecarAccess = new ModelProviderAccess(request -> {}, this.getResilienceConfig());
            cacheParams = this.getCacheParams(this.providerConfig.getCache());
        } else if (this.isClassicSidecarEnabled()) {
            cacheParams = this.getCacheParams(this.sidecarConfig.getCache());
            sidecarAccess = new SidecarAccessV1(request -> {}, this.getResilienceConfig());
        }
        if (sidecarAccess != null && cacheParams != null) {
            return new MetaDataAccessorImpl(new MetaDataAccessorImpl.MetaDataAccessorConfig.Builder().sidecarAccess((SidecarAccess)sidecarAccess).cacheParams(cacheParams).strToEdmx(strToEdmx).strToModel(strToModel).strToI18n(strToI18n).build(), null);
        }
        return null;
    }

    private CacheParams getCacheParams(CdsProperties.MultiTenancy.Sidecar.Cache cache) {
        long maximumSize = cache.getMaxSize();
        long expirationDuration = cache.getExpirationTime();
        long refreshDuration = cache.getRefreshTime();
        return new CacheParams(maximumSize, Duration.ofSeconds(expirationDuration), Duration.ofSeconds(refreshDuration), false, false);
    }

    public ResilienceConfig getResilienceConfig() {
        return ResilienceConfig.builder().numOfRetries(3).retryInterval(Duration.ofMillis(500L)).build();
    }

    public HttpDestination createSidecarDestination(String destinationName, String targetUrl) {
        ServiceBinding binding;
        List<ServiceBinding> uaaBindings = this.xsuaaUtils.getXsuaaServiceBindings();
        ServiceBindingDestinationOptions.OptionsEnhancer enhancer = null;
        if (!uaaBindings.isEmpty()) {
            binding = uaaBindings.get(0);
            enhancer = new ServiceBindingDestinationOptions.OptionsEnhancer(targetUrl);
        } else if (!this.xsuaaUtils.getIasServiceBindings().isEmpty()) {
            binding = this.xsuaaUtils.getIasServiceBindings().get(0);
            enhancer = DynamicModelUtils.proxyOptionsEnhancer(targetUrl);
        } else {
            logger.debug("Initializing MTX sidecar destination '{}' without service binding.", (Object)destinationName);
            return DefaultHttpDestination.builder((String)targetUrl).name(destinationName).build();
        }
        logger.debug("Initializing MTX sidecar destination '{}' using service binding '{}'.", (Object)destinationName, binding.getName().get());
        DefaultHttpDestination http = (DefaultHttpDestination)ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).withOption(enhancer).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
        return this.proxyDestinationWithOverridenName(http, destinationName);
    }

    private HttpDestination proxyDestinationWithOverridenName(DefaultHttpDestination http, String destinationName) {
        return (HttpDestination)Proxy.newProxyInstance(http.getClass().getClassLoader(), new Class[]{HttpDestination.class}, (proxy, method, args) -> {
            if (method.getName().equals("get") && args.length == 1 && (args[0].equals(DestinationProperty.NAME) || args[0].equals("Name"))) {
                return Option.of((Object)destinationName);
            }
            return method.invoke((Object)http, args);
        });
    }

    private static ServiceBindingDestinationOptions.OptionsEnhancer<?> proxyOptionsEnhancer(String targetUrl) {
        try {
            Class<?> clazz = Class.forName("com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions$IasOptions");
            Method method = clazz.getMethod("withTargetUri", String.class);
            return (ServiceBindingDestinationOptions.OptionsEnhancer)method.invoke(null, targetUrl);
        }
        catch (Exception e) {
            throw new ServiceException("Service bindings of type 'identity' are only supported with Cloud SDK 5", new Object[0]);
        }
    }

    static {
        XsuaaOAuth2PropertySupplier.initialize();
        logger = LoggerFactory.getLogger(DynamicModelUtils.class);
    }
}

