/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.destination;

import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import io.vavr.control.Option;
import java.net.URI;
import java.util.Collections;

public class XsuaaOAuth2PropertySupplier
extends DefaultOAuth2PropertySupplier {
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(options -> ServiceBindingUtils.matches(options.getServiceBinding(), "xsuaa"), XsuaaOAuth2PropertySupplier::new);
            initialized = true;
        }
    }

    public XsuaaOAuth2PropertySupplier(ServiceBindingDestinationOptions options) {
        super(options, Collections.emptyList());
    }

    public URI getServiceUri() {
        Option maybeOption = this.options.getOption(UrlOptions.class);
        if (maybeOption.isEmpty()) {
            throw new ServiceException("No `URL` has been provided.", new Object[0]);
        }
        String url = (String)maybeOption.get();
        return URI.create(url);
    }

    public static final class UrlOptions
    implements ServiceBindingDestinationOptions.OptionsEnhancer<String> {
        private String url;

        public UrlOptions(String url) {
            this.url = url;
        }

        public String getValue() {
            return this.url;
        }
    }
}

