/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.util.ConstantLiteralSealingModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Privilege {
    private static final CqnElementRef $USER_REF = CQL.get((String)"$user");
    private static final Modifier LITERAL_SEALING_MODIFIER = new ConstantLiteralSealingModifier();
    private static final Modifier WHERE_MODIFIER = new UserIdNormalizationModifier();
    @JsonProperty(value="grant")
    private List<String> grants = new ArrayList<String>();
    @JsonProperty(value="to")
    private List<String> roles = new ArrayList<String>();
    private String whereCQL;
    private CqnPredicate whereXpr;
    private String cxnWhereCondition;

    public List<String> getGrants() {
        return Collections.unmodifiableList(this.grants);
    }

    public Privilege addGrant(PredefinedGrant grant) {
        return this.addGrant(grant.toString());
    }

    public Privilege addGrant(String grant) {
        Objects.requireNonNull(StringUtils.notEmpty(grant));
        this.grants.add(grant.trim());
        return this;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public Privilege addRole(PredefinedRole role) {
        return this.addRole(role.toString());
    }

    public Privilege addRole(String role) {
        Objects.requireNonNull(StringUtils.notEmpty(role));
        this.roles.add(role.trim());
        return this;
    }

    public String getWhereCQL() {
        return this.whereCQL;
    }

    public void setWhereCQL(String whereCQL) {
        this.whereCQL = whereCQL;
    }

    public CqnPredicate getWhereXpr() {
        return this.whereXpr;
    }

    public void setWhereXpr(CqnPredicate where) {
        this.whereXpr = CQL.copy((CqnPredicate)where, (Modifier)WHERE_MODIFIER);
        this.cxnWhereCondition = this.whereXpr.toJson();
    }

    public boolean hasWhere() {
        return this.whereXpr != null;
    }

    public String getCxnWhereCondition() {
        return this.cxnWhereCondition;
    }

    public void setCxnWhereCondition(String cxnWhereCondition) {
        CqnPredicate where = ExpressionParser.parsePredicate((String)cxnWhereCondition);
        this.whereXpr = CQL.copy((CqnPredicate)where, (Modifier)LITERAL_SEALING_MODIFIER);
        this.cxnWhereCondition = this.whereXpr.toJson();
    }

    public boolean hasWhereUsing(String xpr) {
        return Strings.nullToEmpty((String)this.cxnWhereCondition).contains(xpr);
    }

    public static boolean is(String a, String b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public void readWhere(CdsStructuredType type, Map<String, Object> priv) {
        Object where = priv.get("where");
        if (where != null) {
            if (where instanceof String) {
                String w = (String)where;
                this.setWhereCQL(w);
                Object whereCxn = priv.get("_where");
                if (whereCxn != null) {
                    this.setCxnWhereCondition(whereCxn.toString());
                    return;
                }
            } else if (where instanceof CqnExpression) {
                CqnExpression xpr = (CqnExpression)where;
                this.setWhereXpr(xpr.asPredicate());
                return;
            }
            throw new ErrorStatusException(CdsErrorStatuses.INVALID_WHERE_CONDITION, where, type.getQualifiedName(), "", "");
        }
    }

    public static enum PredefinedGrant {
        ALL("*"),
        WRITE("WRITE");

        private final String grant;

        private PredefinedGrant(String grant) {
            this.grant = grant;
        }

        public boolean is(String grant) {
            return Privilege.is(this.grant, grant);
        }

        public String toString() {
            return this.grant;
        }
    }

    public static enum PredefinedRole {
        ANY_USER("any"),
        AUTHENTICATED_USER("authenticated-user"),
        SYSTEM_USER("system-user"),
        INTERNAL_USER("internal-user");

        private final String role;

        private PredefinedRole(String role) {
            this.role = role;
        }

        public boolean is(String role) {
            return Privilege.is(this.role, role);
        }

        public String toString() {
            return this.role;
        }
    }

    static class UserIdNormalizationModifier
    extends ConstantLiteralSealingModifier {
        UserIdNormalizationModifier() {
        }

        public CqnValue ref(CqnElementRef ref) {
            if (ref.size() == 2 && ref.path().equals("$user.id")) {
                return $USER_REF;
            }
            return super.ref(ref);
        }

        public CqnPredicate exists(Select<?> subQuery) {
            return CQL.exists((CqnSelect)((CqnSelect)CQL.copy(subQuery, (Modifier)this)));
        }

        public CqnPredicate match(CqnMatchPredicate match) {
            Predicate filter = match.predicate().map(p -> CQL.copy((CqnPredicate)p, (Modifier)this)).orElse(null);
            return CQL.match((CqnStructuredTypeRef)match.ref(), (CqnPredicate)filter, (CqnMatchPredicate.Quantifier)match.quantifier());
        }
    }
}

