/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils;

/**
 * Contains constants for supported request parameters.
 */
public interface QueryParameters {

	/**
	 * Request parameter "sap-language".
	 */
	String SAP_LANGUAGE = "sap-language";

	/**
	 * Request parameter "sap-locale".
	 */
	String SAP_LOCALE = "sap-locale";

	/**
	 * Request parameter "sap-valid-at" used for temporal data requests.
	 */
	String VALID_AT = "sap-valid-at";

	/**
	 * Request parameter "sap-valid-from" used for temporal data requests.
	 */
	String VALID_FROM = "sap-valid-from";

	/**
	 * Request parameter "sap-valid-to" used for temporal data requests.
	 */
	String VALID_TO = "sap-valid-to";

	/**
	 * Request parameter "search".
	 */
	String SAP_SEARCH = "search";
}
