/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/**
 * A {@code Restriction} reflects a single restriction for CDS services or entities as defined with @restrict resp. @requires annotations.
 */
public class Restriction {

	private List<Privilege> privileges = new ArrayList<>();

	public Restriction addPrivileges(Privilege... privileges) {
		this.privileges.addAll(Arrays.asList(privileges));
		return this;
	}

	public Restriction addPrivilege(Privilege privilege) {
		privileges.add(privilege);
		return this;
	}

	public Stream<Privilege> privileges() {
		return privileges.stream();
	}
}
