/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.util.CqnStatementUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class OpenTelemetryUtils {
    public static final AttributeKey<String> CDS_TENANT = AttributeKey.stringKey((String)"cds.tenant");
    public static final AttributeKey<String> CDS_SERVICE = AttributeKey.stringKey((String)"cds.service");
    public static final AttributeKey<String> CDS_EVENT_NAME = AttributeKey.stringKey((String)"cds.event_name");
    public static final AttributeKey<String> CDS_ENTITY_NAME = AttributeKey.stringKey((String)"cds.entity_name");
    public static final AttributeKey<String> CDS_OUTBOX_TARGET = AttributeKey.stringKey((String)"cds.outbox.target");
    public static final AttributeKey<String> CDS_CQN_STATEMENT = AttributeKey.stringKey((String)"cds.cqn.statement");
    public static final AttributeKey<String> CDS_CQN_TARGET_ENTITY = AttributeKey.stringKey((String)"cds.cqn.target_entity");
    public static final AttributeKey<String> CDS_CQN_TO_PROTOCOL = AttributeKey.stringKey((String)"cds.cqn.to_protocol");
    public static final AttributeKey<Boolean> CDS_ODATA_IS_BATCH = AttributeKey.booleanKey((String)"cds.odata.is_batch");
    public static final AttributeKey<Boolean> CDS_ODATA_IS_CHANGESET = AttributeKey.booleanKey((String)"cds.odata.is_changeset");
    public static final AttributeKey<Long> HTTP_STATUS_CODE = AttributeKey.longKey((String)"http.status_code");
    public static final AttributeKey<String> HTTP_METHOD = AttributeKey.stringKey((String)"http.method");
    public static final AttributeKey<String> HTTP_SCHEME = AttributeKey.stringKey((String)"http.scheme");
    public static final AttributeKey<String> HTTP_TARGET = AttributeKey.stringKey((String)"http.target");
    private static final String CDS_INSTRUMENTATION_SCOPE = "com.sap.cds";
    private static Tracer tracer = GlobalOpenTelemetry.get().getTracer("com.sap.cds");

    private OpenTelemetryUtils() {
    }

    public static Optional<Span> createSpan(CdsSpanType type) {
        return OpenTelemetryUtils.createSpan(type, null, SpanKind.INTERNAL);
    }

    public static Optional<Span> createSpan(CdsSpanType type, SpanKind kind) {
        return OpenTelemetryUtils.createSpan(type, null, kind);
    }

    public static Optional<Span> createSpan(CdsSpanType type, Context parentContext) {
        return OpenTelemetryUtils.createSpan(type, parentContext, SpanKind.INTERNAL);
    }

    public static Optional<Span> createSpan(CdsSpanType type, Context parentContext, SpanKind kind) {
        if (type.isEnabledForLogging()) {
            SpanBuilder spanBuilder = tracer.spanBuilder(type.toString()).setSpanKind(kind);
            if (!OpenTelemetryUtils.isValidContext(Context.current()) && parentContext != null) {
                spanBuilder.setParent(parentContext);
            }
            return Optional.of(spanBuilder.startSpan());
        }
        return Optional.empty();
    }

    private static boolean isValidContext(Context ctx) {
        Span span = Span.fromContext((Context)ctx);
        return TraceId.isValid((CharSequence)span.getSpanContext().getTraceId()) && SpanId.isValid((CharSequence)span.getSpanContext().getSpanId());
    }

    public static void updateSpan(Optional<Span> span, String serviceName, String eventName, String entityName) {
        span.ifPresent(s -> {
            s.updateName(serviceName + " (" + eventName + ")");
            s.setAttribute(CDS_SERVICE, (Object)String.valueOf(serviceName));
            s.setAttribute(CDS_EVENT_NAME, (Object)String.valueOf(eventName));
            s.setAttribute(CDS_ENTITY_NAME, (Object)String.valueOf(entityName));
        });
    }

    public static void updateSpan(Optional<Span> span, String requestContextId, RequestContext requestContext) {
        span.ifPresent(s -> {
            s.updateName("RequestContext " + requestContextId);
            s.setAttribute("cds.tenant", String.valueOf(requestContext.getUserInfo().getTenant()));
            s.setAttribute("cds.systemUser", String.valueOf(requestContext.getUserInfo().isSystemUser()));
            s.setAttribute("cds.internalUser", String.valueOf(requestContext.getUserInfo().isInternalUser()));
            s.setAttribute("cds.privilegedUser", String.valueOf(requestContext.getUserInfo().isPrivileged()));
            s.setAttribute("cds.locale", String.valueOf(requestContext.getParameterInfo().getLocale()));
            s.setAttribute("cds.validFrom", String.valueOf(requestContext.getParameterInfo().getValidFrom()));
            s.setAttribute("cds.validTo", String.valueOf(requestContext.getParameterInfo().getValidTo()));
        });
    }

    public static void updateSpan(Optional<Span> span, ChangeSetContext changeSetContext) {
        span.ifPresent(s -> s.updateName("ChangeSetContext " + changeSetContext.getId()));
    }

    public static void updateSpan(Optional<Span> span, CdsRuntime runtime, String cqnOperation, CdsEntity targetEntity, CqnStatement cqnStatement, String targetProtocol) {
        span.ifPresent(s -> {
            boolean logValues = runtime.getEnvironment().getCdsProperties().getSecurity().isLogPotentiallySensitive();
            if (cqnStatement != null && CdsSpanType.CQN.logger.isDebugEnabled()) {
                String statement = logValues ? cqnStatement.toJson() : CqnStatementUtils.anonymizeStatement((CqnStatement)cqnStatement).toJson();
                s.setAttribute(CDS_CQN_STATEMENT, (Object)statement);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("CQN " + cqnOperation);
            if (targetEntity != null) {
                builder.append(" " + targetEntity.getName());
                s.setAttribute(CDS_CQN_TARGET_ENTITY, (Object)targetEntity.getQualifiedName());
            }
            s.setAttribute(CDS_CQN_TO_PROTOCOL, (Object)targetProtocol);
            s.updateName(builder.toString());
        });
    }

    public static void endSpan(Optional<Span> span) {
        span.ifPresent(Span::end);
    }

    public static void recordException(Optional<Span> span, Exception e) {
        span.ifPresent(s -> {
            s.recordException((Throwable)e);
            s.setStatus(StatusCode.ERROR);
        });
    }

    @VisibleForTesting
    public static void setTracerProvider(TracerProvider tracerProvider) {
        tracer = tracerProvider.tracerBuilder(CDS_INSTRUMENTATION_SCOPE).setInstrumentationVersion("1.0.0").build();
    }

    public static enum CdsSpanType {
        REQUEST_CONTEXT(Level.DEBUG, "RequestContext"),
        CHANGESET_CONTEXT(Level.DEBUG, "ChangeSetContext"),
        EMIT(Level.DEBUG, "Emit"),
        ODATA_BATCH(Level.INFO, "ODataBatch"),
        CQN(Level.INFO, "CQN"),
        OUTBOX(Level.INFO, "OutboxCollector"),
        DRAFT_GC(Level.INFO, "DraftGarbageCollection");

        private final Level logLevel;
        private final Logger logger;

        private CdsSpanType(Level logLevel, String localName) {
            this.logLevel = logLevel;
            this.logger = LoggerFactory.getLogger((String)("com.sap.cds.otel.span." + localName));
        }

        public Logger getLogger() {
            return this.logger;
        }

        public boolean isEnabledForLogging() {
            return this.logger.isEnabledForLevel(this.logLevel);
        }
    }
}

