/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VcapApplicationParser
implements ApplicationInfo {
    public static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final Logger logger = LoggerFactory.getLogger(VcapApplicationParser.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="application_id")
    private String applicationId = "local";
    @JsonProperty(value="application_name")
    private String applicationName = "local-" + System.getProperty("user.name");
    @JsonProperty(value="application_uris")
    private List<String> applicationUris = new ArrayList<String>();

    public static ApplicationInfo getApplicationInfo(String vcapApplication) {
        if (vcapApplication != null && vcapApplication.trim().length() > 0) {
            try {
                JsonNode vcapNodes = mapper.readTree(vcapApplication);
                if (vcapNodes.has(VCAP_APPLICATION)) {
                    vcapNodes = vcapNodes.get(VCAP_APPLICATION);
                }
                return (ApplicationInfo)mapper.treeToValue((TreeNode)vcapNodes, VcapApplicationParser.class);
            }
            catch (IOException e) {
                logger.warn("Could not parse VCAP_APPLICATION.", (Throwable)e);
            }
        }
        return new VcapApplicationParser();
    }

    public String getId() {
        return this.applicationId;
    }

    public String getName() {
        return this.applicationName;
    }

    public String getUrl() {
        if (this.applicationUris.size() == 1) {
            return this.applicationUris.get(0);
        }
        if (this.applicationUris.size() == 0) {
            return null;
        }
        throw new ErrorStatusException(CdsErrorStatuses.MULTIPLE_APPLICATION_URLS, new Object[0]);
    }
}

