/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.path;

import com.sap.cds.adapter.UrlResourcePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UrlResourcePathBuilder {
    private UrlResourcePathImpl servicePath;

    public static UrlResourcePathBuilder path(String ... paths) {
        UrlResourcePathBuilder builder = new UrlResourcePathBuilder();
        builder.servicePath = new UrlResourcePathImpl();
        builder.servicePath.setPaths(paths);
        return builder;
    }

    public UrlResourcePathBuilder isPublic(boolean isPublic) {
        this.servicePath.isPublic = isPublic;
        return this;
    }

    public UrlResourcePathBuilder recursive() {
        this.servicePath.recursive = true;
        return this;
    }

    public UrlResourcePathBuilder directory() {
        this.servicePath.directory = true;
        return this;
    }

    public UrlResourcePathBuilder publicEvents(Stream<String> publicEvents) {
        publicEvents.collect(Collectors.toCollection(() -> this.servicePath.publicHttpMethods));
        return this;
    }

    public UrlResourcePathBuilder subPath(UrlResourcePath subPath) {
        if (!this.servicePath.subPaths.stream().anyMatch(sp -> sp.getPath().equals(subPath.getPath()))) {
            this.servicePath.subPaths.add(subPath);
        }
        return this;
    }

    public UrlResourcePathBuilder subPaths(Stream<UrlResourcePath> subPaths) {
        subPaths.forEach(subPath -> this.subPath((UrlResourcePath)subPath));
        return this;
    }

    public UrlResourcePath build() {
        this.servicePath.consolidate();
        return this.servicePath;
    }

    private static class UrlResourcePathImpl
    implements UrlResourcePath {
        protected String path;
        protected boolean isPublic;
        protected boolean recursive;
        protected boolean directory;
        protected Set<String> publicHttpMethods = new HashSet<String>();
        protected List<UrlResourcePath> subPaths = new ArrayList<UrlResourcePath>();
        private static final String RECURSICE_PATH = "/**";
        private static final String DIRECTORY_PATH = "/*";

        private UrlResourcePathImpl() {
        }

        private static String normalize(String path) {
            String[] pathParts = path.replaceAll("\\s+", "").split("/");
            return "/" + Stream.of(pathParts).filter(part -> part != null && !part.isEmpty()).collect(Collectors.joining("/"));
        }

        private static String append(String ... pathParts) {
            if (pathParts.length > 0) {
                Object result = Stream.of(pathParts).map(UrlResourcePathImpl::normalize).filter(p -> !p.equals("/")).collect(Collectors.joining());
                if (((String)result).isEmpty() || pathParts.length > 1 && pathParts[pathParts.length - 1].endsWith("/")) {
                    result = (String)result + "/";
                }
                return result;
            }
            return null;
        }

        private static String recursive(String path) {
            String normalizedPath = UrlResourcePathImpl.normalize(path);
            if (!normalizedPath.endsWith(RECURSICE_PATH)) {
                return UrlResourcePathImpl.append(normalizedPath, RECURSICE_PATH);
            }
            return normalizedPath;
        }

        private static String directory(String path) {
            String normalizedPath = UrlResourcePathImpl.normalize(path);
            if (!normalizedPath.endsWith(DIRECTORY_PATH)) {
                return normalizedPath + DIRECTORY_PATH;
            }
            return normalizedPath;
        }

        protected void setPaths(String ... paths) {
            this.path = UrlResourcePathImpl.append(paths);
        }

        protected void consolidate() {
            if (this.isPublic) {
                this.publicHttpMethods.clear();
            }
            this.forAllSubPathsRecursively(this, p -> {
                ((UrlResourcePathImpl)p).path = UrlResourcePathImpl.append(this.path, p.getPath());
            });
            if (this.recursive) {
                this.path = UrlResourcePathImpl.recursive(this.path);
            } else if (this.directory) {
                this.path = UrlResourcePathImpl.directory(this.path);
            }
        }

        private void forAllSubPathsRecursively(UrlResourcePath path, Consumer<UrlResourcePath> func) {
            path.subPaths().forEach(p -> {
                func.accept((UrlResourcePath)p);
                this.forAllSubPathsRecursively((UrlResourcePath)p, func);
            });
        }

        public String getPath() {
            return this.path;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public Stream<String> publicEvents() {
            return this.publicHttpMethods.stream();
        }

        public Stream<UrlResourcePath> subPaths() {
            return this.subPaths.stream();
        }
    }
}

