/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.path;

import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

public class UrlPathUtil {
    public static String cdsEvent2HttpMethod(String cdsEvent) {
        switch (cdsEvent) {
            case "READ": {
                return HttpMethod.GET.name();
            }
            case "DELETE": {
                return HttpMethod.DELETE.name();
            }
            case "CREATE": {
                return HttpMethod.POST.name();
            }
            case "UPSERT": {
                return HttpMethod.PUT.name();
            }
            case "UPDATE": {
                return HttpMethod.PATCH.name();
            }
        }
        return null;
    }

    public static String normalizeBasePath(String basePath) {
        return UrlResourcePathBuilder.path("/" + StringUtils.trim(basePath, '/')).build().getPath();
    }

    public static enum HttpMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        PATCH,
        DELETE,
        TRACE;

    }
}

