/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.services;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.services.utils.model.CqnUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractCqnService
extends ServiceDelegator
implements CqnService {
    protected final CdsRuntime runtime;

    protected AbstractCqnService(String name, CdsRuntime runtime) {
        super(name);
        this.runtime = runtime;
    }

    public Result run(CqnSelect select, Object ... paramValues) {
        return this.run(select, CqnUtils.convertToIndexMap(paramValues));
    }

    public Result run(CqnSelect select, Map<String, Object> namedValues) {
        CdsReadEventContext context = CdsReadEventContext.create((String)this.getTargetEntity((CqnStatement)select));
        context.setCqn(select);
        context.setCqnNamedValues(namedValues);
        this.emit((EventContext)context);
        return context.getResult();
    }

    public Result run(CqnInsert insert) {
        CdsCreateEventContext context = CdsCreateEventContext.create((String)this.getTargetEntity((CqnStatement)insert));
        context.setCqn(insert);
        this.emit((EventContext)context);
        return context.getResult();
    }

    public Result run(CqnUpsert upsert) {
        CdsUpsertEventContext context = CdsUpsertEventContext.create((String)this.getTargetEntity((CqnStatement)upsert));
        context.setCqn(upsert);
        this.emit((EventContext)context);
        return context.getResult();
    }

    public Result run(CqnUpdate update, Object ... paramValues) {
        return this.run(update, CqnUtils.convertToIndexMap(paramValues));
    }

    public Result run(CqnUpdate update, Map<String, Object> namedValues) {
        return this.run(update, this.list(namedValues));
    }

    public Result run(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        CdsUpdateEventContext context = CdsUpdateEventContext.create((String)this.getTargetEntity((CqnStatement)update));
        context.setCqn(update);
        context.setCqnValueSets(valueSets);
        this.emit((EventContext)context);
        return context.getResult();
    }

    public Result run(CqnDelete delete, Object ... paramValues) {
        return this.run(delete, CqnUtils.convertToIndexMap(paramValues));
    }

    public Result run(CqnDelete delete, Map<String, Object> namedValues) {
        return this.run(delete, this.list(namedValues));
    }

    public Result run(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        CdsDeleteEventContext context = CdsDeleteEventContext.create((String)this.getTargetEntity((CqnStatement)delete));
        context.setCqn(delete);
        context.setCqnValueSets(valueSets);
        this.emit((EventContext)context);
        return context.getResult();
    }

    protected List<Map<String, Object>> list(Map<String, Object> map) {
        return map.isEmpty() ? Collections.emptyList() : Collections.singletonList(map);
    }

    protected String getTargetEntity(CqnStatement statement) {
        if (statement.isSelect() && statement.asSelect().from().isSelect()) {
            return this.getTargetEntity((CqnStatement)statement.asSelect().from().asSelect());
        }
        CdsModel model = RequestContext.getCurrent((CdsRuntime)this.runtime).getModel();
        return CdsModelUtils.getEntityPath(statement.ref(), model).target().type().getQualifiedName();
    }
}

