/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.request.ParameterInfo;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class CorrelationIdUtils {
    public static final String CORRELATION_ID_HEADER_KEY = "X-CorrelationID";
    public static final String CORRELATION_ID_HEADER_KEY_ALIAS = "X-Correlation-Id";
    public static final String CORRELATION_ID_FIELD = "correlation_id";
    public static final String CORRELATION_ID_UNKNOWN = "-";

    private CorrelationIdUtils() {
    }

    public static boolean mdcHasEntry() {
        return !CorrelationIdUtils.isUnknown(CorrelationIdUtils.getFromMDC());
    }

    public static void putInMDC(String correlationId) {
        if (!CorrelationIdUtils.isUnknown(correlationId)) {
            MDC.put((String)CORRELATION_ID_FIELD, (String)correlationId);
        }
    }

    public static String getFromMDC() {
        return MDC.get((String)CORRELATION_ID_FIELD);
    }

    public static void clearMDC() {
        MDC.remove((String)CORRELATION_ID_FIELD);
    }

    public static String getOrGenerateCorrelationId(ParameterInfo parameterInfo) {
        return CorrelationIdUtils.getCorrelationId(parameterInfo, correlationId -> CorrelationIdUtils.isUnknown(correlationId) ? UUID.randomUUID().toString() : correlationId);
    }

    public static String getCorrelationId(ParameterInfo parameterInfo) {
        return CorrelationIdUtils.getCorrelationId(parameterInfo, UnaryOperator.identity());
    }

    private static String getCorrelationId(ParameterInfo parameterInfo, UnaryOperator<String> correlationIdProvider) {
        String correlationId = CorrelationIdUtils.getFromMDC();
        if (CorrelationIdUtils.isUnknown(correlationId) && parameterInfo != null && CorrelationIdUtils.isUnknown(correlationId = parameterInfo.getHeader(CORRELATION_ID_HEADER_KEY))) {
            correlationId = parameterInfo.getHeader(CORRELATION_ID_HEADER_KEY_ALIAS);
        }
        return (String)correlationIdProvider.apply(correlationId);
    }

    private static boolean isUnknown(String correlationId) {
        return StringUtils.isEmpty((CharSequence)correlationId) || CORRELATION_ID_UNKNOWN.equals(correlationId);
    }
}

