/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.outbox;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.outbox.OutboxMessage;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.outbox.StoredRequestContext;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.StringUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;

public class OutboxUtils {
    public static final String OUTBOX_MODEL = "cds.outbox.Messages";

    public static boolean hasOutboxModel(CdsModel model) {
        return model.findEntity(OUTBOX_MODEL).isPresent();
    }

    public static <S extends Service> S outboxed(S service, String outboxName, CdsRuntime runtime) {
        OutboxService outbox = null;
        if (!StringUtils.isEmpty(outboxName)) {
            outbox = (OutboxService)runtime.getServiceCatalog().getService(OutboxService.class, outboxName);
        }
        if (outbox == null) {
            outbox = (OutboxService)runtime.getServiceCatalog().getService(OutboxService.class, "OutboxService$InMemory");
        }
        if (outbox != null) {
            return (S)outbox.outboxed(service);
        }
        return service;
    }

    public static OutboxMessage toOutboxMessage(EventContext context) {
        HashMap contextParams = new HashMap();
        context.keySet().forEach(k -> contextParams.put(k, context.get(k)));
        OutboxMessage message = OutboxMessage.create();
        if (context.getTarget() != null) {
            message.setEntity(context.getTarget().getQualifiedName());
        }
        message.setEvent(context.getEvent());
        message.setParams(contextParams);
        return message;
    }

    public static EventContext toEventContext(OutboxMessageEventContext outboxContext) {
        OutboxMessage message = outboxContext.getMessage();
        EventContext context = EventContext.create((String)message.getEvent(), (String)message.getEntity());
        if (message.getParams() != null) {
            message.getParams().forEach((arg_0, arg_1) -> ((EventContext)context).put(arg_0, arg_1));
        }
        return context;
    }

    public static void storeRequestContext(RequestContext requestContext, OutboxMessage message) {
        if (message.getStoredRequestContext() == null) {
            message.setStoredRequestContext(StoredRequestContext.create());
        }
        StoredRequestContext stored = message.getStoredRequestContext();
        UserInfo userInfo = requestContext.getUserInfo();
        stored.setTenant(userInfo.getTenant());
        if (stored.getIsPrivileged() == null) {
            stored.setIsPrivileged(Boolean.valueOf(userInfo.isPrivileged()));
        }
        ParameterInfo parameterInfo = requestContext.getParameterInfo();
        Locale locale = parameterInfo.getLocale();
        Instant validFrom = parameterInfo.getValidFrom();
        Instant validTo = parameterInfo.getValidTo();
        stored.putIfAbsent((Object)"correlationId", (Object)parameterInfo.getCorrelationId());
        stored.putIfAbsent((Object)"locale", (Object)(locale != null ? locale.toLanguageTag() : null));
        stored.putIfAbsent((Object)"validFrom", (Object)(validFrom != null ? validFrom.toString() : null));
        stored.putIfAbsent((Object)"validTo", (Object)(validTo != null ? validTo.toString() : null));
    }

    public static void restoreRequestContext(RequestContextRunner requestContextRunner, OutboxMessage message) {
        StoredRequestContext stored = message.getStoredRequestContext();
        if (stored != null) {
            requestContextRunner.modifyParameters(paramInfo -> {
                String locale = stored.getLocale();
                String validFrom = stored.getValidFrom();
                String validTo = stored.getValidTo();
                paramInfo.setCorrelationId(stored.getCorrelationId());
                paramInfo.setLocale(locale != null ? Locale.forLanguageTag(locale) : null);
                paramInfo.setValidFrom(validFrom != null ? Instant.parse(validFrom) : null);
                paramInfo.setValidTo(validTo != null ? Instant.parse(validTo) : null);
            }).systemUser(stored.getTenant());
            if (stored.getIsPrivileged().booleanValue()) {
                requestContextRunner.privilegedUser();
            }
        }
    }
}

