/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.cert;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.cert.CertValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UclAuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(UclAuthUtils.class);

    public static CertValidator createCertValidator(CdsRuntime runtime) {
        String clientCertificateHeaderName = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getClientCertificateHeader();
        CdsProperties.UnifiedCustomerLandscape.X509 x509 = runtime.getEnvironment().getCdsProperties().getUcl().getX509();
        String expectedIssuer = x509.getCertIssuer();
        String expectedSubject = x509.getCertSubject();
        if (StringUtils.isEmpty(expectedIssuer) || StringUtils.isEmpty(expectedSubject)) {
            logger.warn(CdsErrorStatuses.CERT_ISSUER_SUBJECT_NOT_SET.getDescription());
        }
        return CertValidator.create(clientCertificateHeaderName, expectedIssuer, expectedSubject);
    }

    public static void checkAuthorization(CertValidator certValidator, CdsRuntime runtime) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)runtime);
        boolean isInternalUserAccessEnabled = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getInternalUserAccess().isEnabled();
        if (requestContext.getUserInfo().isPrivileged() || isInternalUserAccessEnabled && requestContext.getUserInfo().isInternalUser()) {
            return;
        }
        certValidator.validateCertFromRequestContext(requestContext);
    }

    public static enum AccessStrategy {
        MTLS("sap:cmp-mtls:v1"),
        OPEN("open");

        private final String value;

        private AccessStrategy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static AccessStrategy fromConfig(CdsRuntime runtime) {
            if (runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().isAuthenticateMetadataEndpoints()) {
                return MTLS;
            }
            return OPEN;
        }
    }
}

