/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.lib.mtx.impl;

import com.sap.cds.CdsException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class CacheParams {
    private final long maximumSize;
    private final long expirationDuration;
    private final TimeUnit expirationDurationUnit;
    private final long refreshDuration;
    private final TimeUnit refreshDurationUnit;
    private final boolean synchronousRefresh;
    private final boolean withBaseModelETag;

    public CacheParams(long maximumSize, Duration expirationDuration, Duration refreshDuration, boolean synchronousRefresh) {
        this(maximumSize, expirationDuration, refreshDuration, synchronousRefresh, false);
    }

    public CacheParams(long maximumSize, Duration expirationDuration, Duration refreshDuration, boolean synchronousRefresh, boolean withBaseModelETag) {
        this.maximumSize = maximumSize;
        this.expirationDuration = expirationDuration.getSeconds();
        this.expirationDurationUnit = TimeUnit.SECONDS;
        this.refreshDuration = refreshDuration.getSeconds();
        this.refreshDurationUnit = TimeUnit.SECONDS;
        this.synchronousRefresh = synchronousRefresh;
        this.withBaseModelETag = withBaseModelETag;
        this.validate();
    }

    private void validate() {
        if (this.maximumSize < 0L) {
            throw new CdsException("Maximum cache size must be greater than or equal to 0");
        }
        if (this.expirationDuration < 0L) {
            throw new CdsException("Expiration duration must be positive");
        }
        if (this.expirationDurationUnit == null) {
            throw new CdsException("Expiration duration unit must not be null");
        }
        if (this.refreshDuration <= 0L) {
            throw new CdsException("Refresh duration must be greater than 0");
        }
        if (this.refreshDurationUnit == null) {
            throw new CdsException("Refresh duration unit must not be null");
        }
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public long getExpirationDuration() {
        return this.expirationDuration;
    }

    public TimeUnit getExpirationDurationUnit() {
        return this.expirationDurationUnit;
    }

    public long getRefreshDuration() {
        return this.refreshDuration;
    }

    public TimeUnit getRefreshDurationUnit() {
        return this.refreshDurationUnit;
    }

    public boolean isSynchronousRefresh() {
        return this.synchronousRefresh;
    }

    public boolean isWithBaseModelETag() {
        return this.withBaseModelETag;
    }
}

