/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.index;

import com.sap.cds.adapter.IndexContentProvider;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class IndexPageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String HEADER = "<!DOCTYPE html>\n    <html>\n        <head>\n            <meta name=\"color-scheme\" content=\"dark light\">\n            <style>\n";
    private static final String BODY = "            </style>\n        </head>\n        <body>\n          <div id=\"welcome\">\n            <h1> Welcome to <i>CAP Java</i> </h1>\n            <p> These are the paths currently served &hellip;\n            <p></p>\n";
    private static final String SECTION_TITLE = "            <br>\n            <h2>%s</h2>\n";
    private static final String END = "           </div><br><br><br>\n        </body>\n    </html>\n";
    private List<IndexContentProvider> contentProviders;

    public IndexPageServlet(List<IndexContentProvider> contentProviders) {
        this.contentProviders = Collections.unmodifiableList(contentProviders);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.write(HEADER);
        out.write(this.loadCss());
        out.write(BODY);
        String contextPath = this.getServletConfig() == null ? req.getContextPath() : this.getServletConfig().getServletContext().getContextPath();
        for (IndexContentProvider provider : this.contentProviders) {
            out.format(SECTION_TITLE, provider.getSectionTitle());
            provider.writeContent(out, contextPath);
        }
        out.write(END);
    }

    private String loadCss() throws IOException {
        int numRead;
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com.sap.cds/index-page/styles.css");
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder imports = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        while ((numRead = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
            imports.append(buffer, 0, numRead);
        }
        return imports.toString();
    }
}

