/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils;

import com.sap.cds.services.handler.annotations.HandlerOrder;

/**
 * This interface is NOT part of the public API.
 * The constants in this interface are intended for internal usage in cds-services.
 * No guarantees are provided that the exact values of these constants remain stable.
 *
 * If its required to order your own custom handlers in your application,
 * refer to {@link HandlerOrder} and the respective constants defined there.
 */
public interface OrderConstants {

	interface On {

		// priority of built-in default ON handlers provided by the framework
		int DEFAULT_ON = 10 * HandlerOrder.AFTER + HandlerOrder.LATE;
		// makes sure reject handler is last
		int REJECT = Integer.MAX_VALUE;
		int AUTO_COMPLETE = REJECT - 1;

		// before default ON handlers
		int FEATURE = 1 * HandlerOrder.BEFORE + DEFAULT_ON;

		// before usual custom ON handlers
		int PRIORITY = HandlerOrder.AFTER + HandlerOrder.EARLY;

	}

	interface Before {

		// only used for persistence (not directly exposed as external API)
		int TRANSACTION_BEGIN = 20 * HandlerOrder.BEFORE + HandlerOrder.EARLY;

		// before usual custom handlers
		int CHECK_ENTITY_FITS = 10 * HandlerOrder.BEFORE + HandlerOrder.EARLY;
		int CHECK_STATEMENT = HandlerOrder.AFTER  + CHECK_ENTITY_FITS;
		int CHECK_STATIC_AUTHORIZATION = HandlerOrder.AFTER + CHECK_STATEMENT;
		int CHECK_INSTANCE_BASED_AUTHORIZATION = HandlerOrder.AFTER + CHECK_STATIC_AUTHORIZATION;
		int CHECK_AUTHORIZATION = CHECK_STATIC_AUTHORIZATION;
		int CHECK_CAPABILITIES = HandlerOrder.AFTER + CHECK_INSTANCE_BASED_AUTHORIZATION;
		int FILTER_FIELDS = HandlerOrder.AFTER + CHECK_CAPABILITIES;

		// after usual custom handlers
		int CALCULATE_FIELDS = 10 * HandlerOrder.AFTER + HandlerOrder.LATE;
		int VALIDATE_FIELDS = HandlerOrder.AFTER + CALCULATE_FIELDS;
		int THROW_IF_ERROR = HandlerOrder.AFTER + VALIDATE_FIELDS;

		// after validations
		int ADAPT_STATEMENT = HandlerOrder.AFTER + THROW_IF_ERROR;
	}

	interface After {

		// before usual custom handlers
		int ADD_FIELDS = 10 * HandlerOrder.BEFORE + HandlerOrder.EARLY;

		// auditlog: personal data after handlers
		int AUDIT = HandlerOrder.AFTER + ADD_FIELDS;
	}

}
