/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils;

import java.time.Instant;

import com.sap.cds.SessionContext;
import com.sap.cds.UserContext;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;

public class SessionContextUtils {

	private SessionContextUtils() {
		// hidden
	}

	/**
	 * Creates a {@link SessionContext} from the given {@link EventContext}.
	 * @param context the {@link EventContext}
	 * @return the {@link SessionContext}
	 */
	public static SessionContext toSessionContext(EventContext context) {
		return toSessionContext(context.getUserInfo(), context.getParameterInfo());
	}

	/**
	 * Creates a {@link SessionContext} from the given {@link RequestContext}.
	 * @param context the {@link RequestContext}
	 * @return the {@link SessionContext}
	 */
	public static SessionContext toSessionContext(RequestContext context) {
		return toSessionContext(context.getUserInfo(), context.getParameterInfo());
	}

	private static SessionContext toSessionContext(UserInfo userInfo, ParameterInfo parameterInfo) {
		// TODO should we be able to get the now timestamp from the context?
		return SessionContext.create().setUserContext(toUserContext(userInfo, parameterInfo))
			.setValidFrom(parameterInfo.getValidFrom())
			.setValidTo(parameterInfo.getValidTo())
			.setNow(Instant.now());
	}

	private static UserContext toUserContext(UserInfo userInfo, ParameterInfo parameterInfo) {
		return UserContext
			.create()
			.setId(userInfo.getName())
			.setLocale(parameterInfo.getLocale())
			.setTenant(userInfo.getTenant())
			.setAttributes(userInfo.getAttributes());
	}

}
