/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.services.utils.lib.mtx.impl;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.JDBCDataStoreConnector;
import com.sap.cds.impl.SystemPropertyDataStoreConfiguration;
import com.sap.cds.services.utils.lib.mtx.CdsDataStoreConnectorCreator;
import com.sap.cds.services.utils.lib.mtx.MetaDataAccessor;
import com.sap.cds.transaction.TransactionManager;

import javax.sql.DataSource;
import java.util.function.Function;

public class CdsDataStoreConnectorCreatorImpl implements CdsDataStoreConnectorCreator {
	private final MetaDataAccessor<?> metaDataAccessor;
	private final Function<String, DataSource> dataSourceForTenant;
	private final TransactionManager cdsTransactionManager;
	private final DataStoreConfiguration config;

	public CdsDataStoreConnectorCreatorImpl(MetaDataAccessor<?> metaDataAccessor,
			Function<String, DataSource> dataSourceForTenant, TransactionManager cdsTransactionManager,
			DataStoreConfiguration config) {
		this.metaDataAccessor = metaDataAccessor;
		this.dataSourceForTenant = dataSourceForTenant;
		this.cdsTransactionManager = cdsTransactionManager;
		this.config = config;
	}

	public CdsDataStoreConnectorCreatorImpl(MetaDataAccessor<?> metaDataAccessor,
			Function<String, DataSource> dataSourceForTenant, TransactionManager cdsTransactionManager) {
		this(metaDataAccessor, dataSourceForTenant, cdsTransactionManager, new SystemPropertyDataStoreConfiguration());
	}

	@Override
	public CdsDataStoreConnector create(String tenantId) {
		return JDBCDataStoreConnector.create(metaDataAccessor.getCdsModel(tenantId), cdsTransactionManager)
				.datasource(dataSourceForTenant.apply(tenantId)).config(config).build();
	}
}
