/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.services.utils.lib.mtx.impl;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Value class containing parameters of xsuua service instance
 */
@Deprecated(forRemoval = true, since = "3.4.0")
public class XsuaaParams {
	public static final String CLIENTID = "clientid";
	public static final String CLIENT_SECRET = "clientsecret";
	public static final String URL = "url";
	public static final String CERTIFICATE = "certificate";
	public static final String CERTURL = "certurl";
	public static final String XSAPPNAME = "xsappname";
	public static final String KEY = "key";

	private final Map<String, Object> credentials = new HashMap<>();

	/**
	 * @param url          URL of xsuaa service instance (stored in VCAP_SERVICES)
	 * @param clientId     client id  (stored in VCAP_SERVICES)
	 * @param clientSecret client secret  (stored in VCAP_SERVICES)
	 * @deprecated replaced by constructor with credentials.
	 */

	@Deprecated(forRemoval = true, since = "3.0.0")
	public XsuaaParams(String url, String clientId, String clientSecret) {
		credentials.put(CLIENT_SECRET, clientSecret);
		credentials.put(CLIENTID, clientId);
		credentials.put(URL, url);
	}

	/**
	 * @param credentials Map with all credentials of xsuaa binding
	 */
	public XsuaaParams(Map<String, Object> credentials) {
		this.credentials.putAll(credentials);
	}

	/**
	 * @return URL
	 */
	public String getUrl() {
		return credentials.get(URL).toString();
	}

	/**
	 * @param url change URL after creation, needed in test cases.
	 */
	public void updateUrl(String url) {
		credentials.put(URL, url);
	}

	/**
	 * @return client id
	 */
	public String getClientId() {
		return credentials.get(CLIENTID).toString();
	}

	/**
	 * @return OAuth2 service configuration
	 */
	public OAuth2ServiceConfiguration getOAuth2ServiceConfiguration() {
		Map<String, String> xsuaaCredentials = new HashMap<>();
		credentials.forEach((k, v) -> {
			if (v != null) {
				xsuaaCredentials.put(k, v.toString());
			}
		});
		return OAuth2ServiceConfigurationBuilder.forService(Service.XSUAA).withProperties(xsuaaCredentials).build();
	}
}
