/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.services.utils.lib.tools.api;

import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;

import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;

/**
 * Define syntax of fluent API to create a service endpoint
 */

public interface ServiceEndpointMediators {
    /*
         at -> destinationName -> path ---> |returnCodeChecker            | ->|retry     | -> forReturnCodes-> config -> end
                                            |throwNoExceptionForReturnCode|   |doNotRetry| -> end                                                                                                    |
     */

	public static interface FromCreate {
		FromDestinationName destinationName(String destinationName);

		FromDestinationName destination(HttpDestination destination);
	}


	public interface FromDestinationName {
		FromPath path(String path);
	}

	public interface FromPath {
		FromCodeChecker returnCodeChecker(IntFunction<Exception> checkFunction);

		FromCodeChecker throwNoExceptionForReturnCode();
	}

	public interface FromCodeChecker {
		FromRetry retry();

		FromDoNotRetry doNotRetry();
	}

	public interface FromDoNotRetry extends End {

	}

	public interface FromRetry {
		FromReturnCodes forReturnCodes(Set<Integer> returnCodes);

		FromReturnCodes forReturnCodes(List<Integer> returnCodes);

		FromReturnCodes forReturnCodes(Integer... returnCodes);

	}

	public interface FromReturnCodes {
		FromConfig config(ResilienceConfig config);
	}

	public interface FromConfig extends End {
	}


	public interface End {
		ServiceEndpoint end() throws InternalException;
	}

}
