/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.lib.tools.impl;

import com.sap.cds.services.utils.lib.tools.impl.SupplierWithException;
import com.sap.cds.services.utils.lib.tools.impl.VoidConsumerWithException;
import com.sap.cds.services.utils.lib.tools.impl.WaitTimeFunction;
import com.sap.cds.services.utils.lib.tools.impl.WaitTimeSupplier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Retry {
    public static final WaitTimeFunction EXP_WAIT_TIME_FUNCTION = (time, numberOfRetries) -> Duration.ofMillis(Double.valueOf((double)time.toMillis() * Math.pow(2.0, numberOfRetries)).longValue());
    public static final WaitTimeFunction CONSTANT_WAIT_TIME_FUNCTION = (time, numberOfRetries) -> time;
    public static final WaitTimeFunction LINEAR_WAIT_TIME_FUNCTION = (time, numberOfRetries) -> Duration.ofMillis(time.toMillis() * (long)(numberOfRetries + 1));
    private final int numOfRetries;
    private final List<Class> retryExceptions = new ArrayList<Class>();
    private final Duration baseWaitTime;
    private final WaitTimeFunction waitTimeFunction;

    private Retry(int numOfRetries, List<Class<? extends Throwable>> retryExceptions, Duration baseWaitTime, WaitTimeFunction waitTimeFunction) {
        if (waitTimeFunction == null) {
            waitTimeFunction = CONSTANT_WAIT_TIME_FUNCTION;
        }
        this.numOfRetries = numOfRetries;
        this.retryExceptions.addAll(retryExceptions);
        this.baseWaitTime = baseWaitTime != null ? baseWaitTime : Duration.ofSeconds(1L);
        this.waitTimeFunction = waitTimeFunction;
    }

    public <T> T execute(SupplierWithException<T> supplier) throws Exception {
        int retryRun = -1;
        while (true) {
            ++retryRun;
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                WaitTimeSupplier waitTimeSupplier;
                if (retryRun >= this.numOfRetries || !this.isARetryException(e)) {
                    throw e;
                }
                if (e instanceof WaitTimeSupplier && (waitTimeSupplier = (WaitTimeSupplier)((Object)e)).getWaitTime() != null) {
                    long requestedWaitTime = waitTimeSupplier.getWaitTime().toMillis();
                    if (requestedWaitTime > this.getMaximumWaitTime()) {
                        throw e;
                    }
                    this.sleep(retryRun, waitTimeSupplier.getWaitTime());
                    continue;
                }
                this.sleep(retryRun, null);
                continue;
            }
            break;
        }
    }

    public void execute(VoidConsumerWithException consumer) throws Exception {
        this.execute(() -> {
            consumer.accept();
            return null;
        });
    }

    private void sleep(int retryRun, Duration requestedWaitTime) {
        try {
            if (requestedWaitTime != null) {
                Thread.sleep(requestedWaitTime.toMillis());
            } else {
                Thread.sleep(this.waitTimeFunction.getWaitTime(this.baseWaitTime, retryRun).toMillis());
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean isARetryException(Throwable e) {
        return this.retryExceptions.stream().anyMatch(clazz -> clazz.isInstance(e));
    }

    private long getMaximumWaitTime() {
        long maxWaitTime = 0L;
        for (int i = 0; i < this.numOfRetries; ++i) {
            maxWaitTime += this.waitTimeFunction.getWaitTime(this.baseWaitTime, i).toMillis();
        }
        return maxWaitTime;
    }

    public static final class RetryBuilder {
        private int numOfRetries;
        private List<Class<? extends Throwable>> retryExceptions = new ArrayList<Class<? extends Throwable>>();
        private Duration baseWaitTime;
        private WaitTimeFunction waitTimeFunction;

        private RetryBuilder() {
        }

        public static RetryBuilder create() {
            return new RetryBuilder();
        }

        public RetryBuilder numOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        public RetryBuilder retryExceptions(Class<? extends Throwable> ... retryExceptions) {
            this.retryExceptions = Arrays.asList(retryExceptions);
            return this;
        }

        public RetryBuilder retryExceptions(Set<Class<? extends Throwable>> retryExceptions) {
            if (retryExceptions != null) {
                this.retryExceptions.addAll(retryExceptions);
            }
            return this;
        }

        public RetryBuilder baseWaitTime(Duration baseWaitTime) {
            this.baseWaitTime = baseWaitTime;
            return this;
        }

        public RetryBuilder waitTimeFunction(WaitTimeFunction waitTimeFunction) {
            this.waitTimeFunction = waitTimeFunction;
            return this;
        }

        public Retry build() {
            return new Retry(this.numOfRetries, this.retryExceptions, this.baseWaitTime, this.waitTimeFunction);
        }
    }
}

