/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.Privilege;
import com.sap.cds.services.utils.model.Restriction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CdsModelUtils {
    public static final String $USER = "$user";
    private final CdsRuntime runtime;

    public CdsModelUtils(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Optional<Boolean> isPublic(CdsAnnotatable cdsModelElement) {
        String mode = this.runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getMode().trim();
        if (mode.equalsIgnoreCase("always")) {
            return Optional.of(false);
        }
        if (mode.equalsIgnoreCase("never")) {
            return Optional.of(true);
        }
        Restriction restriction = CdsModelUtils.getRestrictionOrNull(cdsModelElement);
        if (restriction != null) {
            return Optional.of(restriction.privileges().anyMatch(priv -> priv.getGrants().contains(Privilege.PredefinedGrant.ALL.toString()) && priv.getRoles().contains(Privilege.PredefinedRole.ANY_USER.toString()) && !priv.hasWhereUsing($USER)));
        }
        if (cdsModelElement instanceof CdsService) {
            return Optional.of(mode.equalsIgnoreCase("model-relaxed"));
        }
        return Optional.empty();
    }

    public List<String> getPublicEvents(CdsAnnotatable cdsModelElement) {
        Set<Object> publicEvents = new HashSet();
        Restriction restriction = CdsModelUtils.getRestrictionOrNull(cdsModelElement);
        if (restriction != null) {
            publicEvents = restriction.privileges().filter(priv -> priv.getRoles().contains(Privilege.PredefinedRole.ANY_USER.toString()) && !priv.hasWhereUsing($USER)).flatMap(priv -> priv.getGrants().stream()).collect(Collectors.toSet());
        }
        if (publicEvents.contains(Privilege.PredefinedGrant.ALL.toString())) {
            publicEvents = Collections.singleton(Privilege.PredefinedGrant.ALL.toString());
        }
        return publicEvents.stream().collect(Collectors.toList());
    }

    public static Restriction getRestrictionOrNull(CdsAnnotatable cdsModelElement) {
        Restriction result = CdsModelUtils.readPrivileges(cdsModelElement);
        Object annotationRoles = CdsAnnotations.REQUIRES.getOrDefault(cdsModelElement);
        if (annotationRoles != null) {
            if (result == null) {
                result = new Restriction();
            }
            List roles = List.of();
            if (annotationRoles instanceof String) {
                String r = (String)annotationRoles;
                roles = List.of(r);
            } else if (annotationRoles instanceof List) {
                List r;
                roles = r = (List)annotationRoles;
            }
            for (String role : roles) {
                result.addPrivilege(new Privilege().addGrant(Privilege.PredefinedGrant.ALL).addRole(role));
            }
        }
        return result;
    }

    private static Restriction readPrivileges(CdsAnnotatable cdsModelElement) {
        String entityName;
        List privileges = (List)CdsAnnotations.RESTRICT.getOrDefault(cdsModelElement);
        if (cdsModelElement instanceof CdsStructuredType) {
            CdsStructuredType t = (CdsStructuredType)cdsModelElement;
            v0 = t.getQualifiedName();
        } else {
            v0 = entityName = null;
        }
        if (privileges != null) {
            Restriction result = new Restriction();
            for (Map privilege : privileges) {
                result.addPrivilege(new Privilege(privilege, entityName));
            }
            return result;
        }
        return null;
    }

    public static AnalysisResult getEntityPath(CqnStructuredTypeRef ref, CdsModel model) {
        try {
            return CqnAnalyzer.create((CdsModel)model).analyze(ref);
        }
        catch (CdsElementNotFoundException e) {
            throw new ErrorStatusException(CdsErrorStatuses.ELEMENT_NOT_FOUND, new Object[]{e.getElementName(), e.getDefinition().getName(), e});
        }
        catch (CdsDefinitionNotFoundException e) {
            throw new ErrorStatusException(CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{e.getQualifiedName(), e});
        }
    }

    public static boolean isChildEntity(CqnStructuredTypeRef ref, CdsModel model) {
        CdsEntity entity = null;
        for (CqnReference.Segment s : ref.segments()) {
            if (entity == null) {
                entity = model.getEntity(s.id());
                continue;
            }
            String name = entity.getQualifiedName();
            CdsElement association = (CdsElement)entity.findAssociation(s.id()).orElseThrow(() -> new ErrorStatusException(CdsErrorStatuses.ASSOCIATION_NOT_FOUND, s.id(), name));
            if (((CdsAssociationType)association.getType().as(CdsAssociationType.class)).isComposition()) continue;
            return false;
        }
        return true;
    }

    public static CdsEntity getTargetEntity(CqnSelect select, CdsModel model) {
        return CdsModelUtils.getEntityPath(select, model).targetEntity();
    }

    public static CdsEntity getTargetEntity(CqnStructuredTypeRef ref, CdsModel model) {
        return CdsModelUtils.getEntityPath(ref, model).targetEntity();
    }

    public static AnalysisResult getEntityPath(CqnSelect select, CdsModel model) {
        return CdsModelUtils.getEntityPath(select.ref(), model);
    }

    public static CdsEntity getRefTarget(CqnStructuredTypeRef ref, CdsEntity target) {
        CdsEntity refTarget = target;
        for (CqnReference.Segment s : ref.segments()) {
            if (s.id().equals("*")) {
                return null;
            }
            refTarget = (CdsEntity)refTarget.getTargetOf(s.id());
        }
        return refTarget;
    }

    public static String getTargetKeysAsString(CdsModel model, CqnStatement statement) {
        return CdsModelUtils.getTargetKeysAsString(model, statement.ref());
    }

    public static String getTargetKeysAsString(CdsModel model, CqnStructuredTypeRef ref) {
        AnalysisResult analysis = CqnAnalyzer.create((CdsModel)model).analyze(ref);
        String keyValues = analysis.targetKeyValues().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(","));
        return keyValues;
    }

    public static Optional<CdsFunction> findFunction(CdsService service, CdsEntity entity, String name) {
        Optional<CdsFunction> result = service.functions().filter(f -> f.getName().equals(name)).findAny();
        if (entity != null && result.isEmpty()) {
            return entity.functions().filter(f -> f.getName().equals(name)).findAny();
        }
        return result;
    }

    public static Optional<CdsAction> findAction(CdsService service, CdsEntity entity, String name) {
        Optional<CdsAction> result = service.actions().filter(a -> a.getName().equals(name)).findAny();
        if (entity != null && result.isEmpty()) {
            return entity.actions().filter(a -> a.getName().equals(name)).findAny();
        }
        return result;
    }
}

