/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.lib.mtx.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.sap.cds.CdsException;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.utils.lib.mtx.MetaDataAccessor;
import com.sap.cds.services.utils.lib.mtx.ModelId;
import com.sap.cds.services.utils.lib.mtx.impl.CacheParams;
import com.sap.cds.services.utils.lib.mtx.impl.SidecarAccess;
import com.sap.cds.services.utils.lib.mtx.impl.SidecarResponse;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorImpl<M>
implements MetaDataAccessor<M> {
    private static final String BASEMODEL_ETAG = "\"basemodel\"";
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorImpl.class);
    public static final String CACHE_NOT_CONFIGURED = "Cache not configured";
    private final Cache<CdsModel> modelIdToCdsModel;
    private final Cache<M> modelIdToEdmxModel;
    private final Cache<MetaDataAccessor.I18n> modelIdToI18n;

    public MetaDataAccessorImpl(MetaDataAccessorConfig config, Ticker cacheTicker) {
        if (cacheTicker == null) {
            cacheTicker = Ticker.systemTicker();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        SidecarAccess sidecarAccess = config.getSidecarAccess();
        CacheParams cacheParams = config.getCacheParams();
        EdmxModelCreator<?> strToEdmx = config.getStrToEdmx();
        CdsModelCreator strToModel = config.getStrToModel();
        I18nResourceCreator strToI18n = config.getStrToI18n();
        this.modelIdToCdsModel = strToModel == null ? null : new CdsCache(sidecarAccess, strToModel, cacheParams, cacheTicker, executorService);
        this.modelIdToEdmxModel = strToEdmx == null ? null : new EdmxCache(sidecarAccess, strToEdmx, cacheParams, cacheTicker, executorService);
        this.modelIdToI18n = strToI18n == null ? null : new I18nCache(sidecarAccess, strToI18n, cacheParams, cacheTicker, executorService);
    }

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, Ticker cacheTicker) {
        this(new MetaDataAccessorConfig.Builder().sidecarAccess(sidecarAccess).cacheParams(cacheParams).strToEdmx(strToEdmx).strToModel(csn -> CdsModelReader.read((CdsModelReader.Config)new CdsModelReader.Config.Builder().setIncludeUIAnnotations(true).build(), (String)csn, (boolean)true)).build(), cacheTicker);
    }

    @Override
    public CdsModel getCdsModel(ModelId key, int maxAgeSeconds) {
        if (this.modelIdToCdsModel == null) {
            throw new CdsException(CACHE_NOT_CONFIGURED);
        }
        return this.modelIdToCdsModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public M getEdmx(ModelId key, int maxAgeSeconds) throws CdsException {
        if (this.modelIdToEdmxModel == null) {
            throw new CdsException(CACHE_NOT_CONFIGURED);
        }
        return this.modelIdToEdmxModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    @Override
    public MetaDataAccessor.I18n getI18n(ModelId modelId, int maxAgeSeconds) {
        if (this.modelIdToI18n == null) {
            throw new CdsException(CACHE_NOT_CONFIGURED);
        }
        return this.modelIdToI18n.getOrLoadIfStale(modelId, maxAgeSeconds);
    }

    @Override
    public void evict(String tenantId) {
        if (this.modelIdToCdsModel != null) {
            this.modelIdToCdsModel.evict(tenantId);
        }
        if (this.modelIdToEdmxModel != null) {
            this.modelIdToEdmxModel.evict(tenantId);
        }
        if (this.modelIdToI18n != null) {
            this.modelIdToI18n.evict(tenantId);
        }
    }

    @Override
    public void refresh(String tenantId, int maxAgeSeconds) {
        if (this.modelIdToCdsModel != null) {
            this.modelIdToCdsModel.refresh(tenantId, maxAgeSeconds);
        }
        if (this.modelIdToEdmxModel != null) {
            this.modelIdToEdmxModel.refresh(tenantId, maxAgeSeconds);
        }
        if (this.modelIdToI18n != null) {
            this.modelIdToI18n.refresh(tenantId, maxAgeSeconds);
        }
    }

    public static class MetaDataAccessorConfig {
        private SidecarAccess sidecarAccess;
        private CacheParams cacheParams;
        private EdmxModelCreator<?> strToEdmx;
        private CdsModelCreator strToModel;
        private I18nResourceCreator strToI18n;

        private MetaDataAccessorConfig() {
        }

        public SidecarAccess getSidecarAccess() {
            return this.sidecarAccess;
        }

        public CacheParams getCacheParams() {
            return this.cacheParams;
        }

        public EdmxModelCreator<?> getStrToEdmx() {
            return this.strToEdmx;
        }

        public CdsModelCreator getStrToModel() {
            return this.strToModel;
        }

        public I18nResourceCreator getStrToI18n() {
            return this.strToI18n;
        }

        public static class Builder {
            private SidecarAccess sidecarAccess;
            private CacheParams cacheParams;
            private EdmxModelCreator<?> strToEdmx;
            private CdsModelCreator strToModel;
            private I18nResourceCreator strToI18n;

            public Builder sidecarAccess(SidecarAccess sidecarAccess) {
                this.sidecarAccess = sidecarAccess;
                return this;
            }

            public Builder cacheParams(CacheParams cacheParams) {
                this.cacheParams = cacheParams;
                return this;
            }

            public Builder strToEdmx(EdmxModelCreator<?> strToEdmx) {
                this.strToEdmx = strToEdmx;
                return this;
            }

            public Builder strToModel(CdsModelCreator strToModel) {
                this.strToModel = strToModel;
                return this;
            }

            public Builder strToI18n(I18nResourceCreator strToI18n) {
                this.strToI18n = strToI18n;
                return this;
            }

            public MetaDataAccessorConfig build() {
                MetaDataAccessorConfig config = new MetaDataAccessorConfig();
                config.sidecarAccess = this.sidecarAccess;
                config.cacheParams = this.cacheParams;
                config.strToEdmx = this.strToEdmx;
                config.strToModel = this.strToModel;
                config.strToI18n = this.strToI18n;
                return config;
            }
        }
    }

    @FunctionalInterface
    public static interface EdmxModelCreator<M> {
        public M parse(String var1, String var2);

        default public M getBaseModel(String serviceName) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface CdsModelCreator {
        public CdsModel parse(String var1);

        default public CdsModel getBaseModel() {
            return null;
        }
    }

    @FunctionalInterface
    public static interface I18nResourceCreator {
        public MetaDataAccessor.I18n parse(String var1, String var2);

        default public MetaDataAccessor.I18n getBaseModel(String language) {
            return null;
        }
    }

    private static abstract class Cache<V> {
        private final Ticker ticker;
        private final LoadingCache<ModelId, Entry<V>> cache;
        private final String cacheName = this.getClass().getSimpleName();
        private final boolean isWithBaseModelEtag;

        protected Cache(CacheParams params, Ticker ticker, ExecutorService executorService) {
            this.ticker = ticker;
            this.isWithBaseModelEtag = params.isWithBaseModelETag();
            this.cache = Caffeine.newBuilder().maximumWeight(params.getMaximumSize()).weigher(new Weigher<ModelId, Entry<V>>(){

                public @NonNegative int weigh(ModelId key, Entry<V> value) {
                    if (isWithBaseModelEtag && MetaDataAccessorImpl.BASEMODEL_ETAG.equals(value.getETag())) {
                        return 0;
                    }
                    return 1;
                }
            }).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit()).refreshAfterWrite(params.getRefreshDuration(), params.getRefreshDurationUnit()).executor((Executor)executorService).ticker(ticker).evictionListener((k, v, c) -> {
                if (c.wasEvicted()) {
                    logger.debug("Evicted '{}' in cache '{}' with cause '{}'", new Object[]{k, this.cacheName, c});
                }
            }).build(new CacheLoader<ModelId, Entry<V>>(){

                public Entry<V> load(ModelId key) {
                    return this.load(key, null);
                }

                public Entry<V> reload(ModelId key, Entry<V> oldValue) {
                    logger.debug("Reloading '{}' in cache '{}'", (Object)key, (Object)cacheName);
                    try {
                        return this.load(key, oldValue);
                    }
                    catch (Exception e) {
                        logger.error("Reloading '{}' failed", (Object)key, (Object)e);
                        return oldValue;
                    }
                }
            });
        }

        public void evict(String tenantId) {
            logger.debug("Evicting tenant '{}' from cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, arg_0 -> this.cache.invalidate(arg_0));
        }

        public void refresh(String tenantId, int maxAgeSeconds) {
            logger.debug("Refreshing tenant '{}' in cache '{}'", (Object)tenantId, (Object)this.cacheName);
            this.forTenant(tenantId, k -> this.getOrLoadIfStale((ModelId)k, maxAgeSeconds));
        }

        private void forTenant(String tenantId, Consumer<ModelId> action) {
            this.cache.asMap().keySet().stream().filter(k -> Objects.equals(tenantId, k.getTenantId())).forEach(action);
        }

        public V getOrLoadIfStale(ModelId key, int maxAgeSeconds) {
            Entry<V> entry;
            long maxAgeNanos = (long)maxAgeSeconds * 1000000000L;
            try {
                entry = (Entry<V>)this.cache.get((Object)key);
            }
            catch (RuntimeException e) {
                throw new CdsException((Throwable)e);
            }
            if (this.ticker.read() - entry.refreshed() > maxAgeNanos) {
                Entry<V> loaded = this.load(key, entry);
                if (loaded != entry) {
                    this.cache.put((Object)key, loaded);
                    entry = loaded;
                }
            } else {
                logger.debug("'{}' in cache '{}' is not older than '{}'", new Object[]{key, this.cacheName, maxAgeSeconds});
            }
            return entry.getEntry();
        }

        private Entry<V> load(ModelId key, Entry<V> oldEntry) {
            logger.debug("Loading '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
            String eTag = oldEntry != null ? oldEntry.getETag() : (this.isWithBaseModelEtag ? MetaDataAccessorImpl.BASEMODEL_ETAG : null);
            long beforeAccess = this.ticker.read();
            SidecarResponse model = this.access(key, eTag);
            if (oldEntry != null && model.isNotModified()) {
                oldEntry.refresh(beforeAccess);
                logger.debug("Refreshed unchanged '{}' in cache '{}'", (Object)key, (Object)this.cacheName);
                return oldEntry;
            }
            V value = MetaDataAccessorImpl.BASEMODEL_ETAG.equals(eTag) && model.isNotModified() ? this.getBaseModel(key) : this.parse(key, model.getPayload());
            return new Entry<V>(value, model.getETag(), beforeAccess);
        }

        abstract SidecarResponse access(ModelId var1, String var2);

        abstract V parse(ModelId var1, String var2);

        abstract V getBaseModel(ModelId var1);
    }

    private static class CdsCache
    extends Cache<CdsModel> {
        private final SidecarAccess sidecarAccess;
        private final CdsModelCreator strToModel;

        public CdsCache(SidecarAccess sidecarAccess, CdsModelCreator strToModel, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToModel = strToModel;
        }

        @Override
        SidecarResponse access(ModelId key, String eTag) {
            return this.sidecarAccess.getCsn(key, eTag);
        }

        @Override
        CdsModel parse(ModelId key, String csn) {
            return this.strToModel.parse(csn);
        }

        @Override
        CdsModel getBaseModel(ModelId key) {
            return this.strToModel.getBaseModel();
        }
    }

    private static class EdmxCache<M>
    extends Cache<M> {
        private final SidecarAccess sidecarAccess;
        private final EdmxModelCreator<M> strToEdmx;

        public EdmxCache(SidecarAccess sidecarAccess, EdmxModelCreator<M> strToEdmx, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToEdmx = strToEdmx;
        }

        @Override
        SidecarResponse access(ModelId key, String eTag) {
            return this.sidecarAccess.getEdmx(key, eTag);
        }

        @Override
        M parse(ModelId key, String model) {
            return this.strToEdmx.parse(model, key.getServiceName().orElse(null));
        }

        @Override
        M getBaseModel(ModelId key) {
            return this.strToEdmx.getBaseModel(key.getServiceName().orElse(null));
        }
    }

    private static class I18nCache
    extends Cache<MetaDataAccessor.I18n> {
        private final SidecarAccess sidecarAccess;
        private final I18nResourceCreator strToI18n;

        public I18nCache(SidecarAccess sidecarAccess, I18nResourceCreator strToI18n, CacheParams params, Ticker ticker, ExecutorService executorService) {
            super(params, ticker, executorService);
            this.sidecarAccess = sidecarAccess;
            this.strToI18n = strToI18n;
        }

        @Override
        SidecarResponse access(ModelId key, String eTag) {
            return this.sidecarAccess.getI18n(key, eTag);
        }

        @Override
        MetaDataAccessor.I18n parse(ModelId key, String json) {
            return this.strToI18n.parse(json, key.getLanguage().orElse(""));
        }

        @Override
        MetaDataAccessor.I18n getBaseModel(ModelId key) {
            return this.strToI18n.getBaseModel(key.getLanguage().orElse(""));
        }
    }

    private static class Entry<V> {
        private final V entry;
        private final String eTag;
        private final AtomicLong refreshed;

        public Entry(V entry, String eTag, long refreshed) {
            this.entry = entry;
            this.eTag = eTag != null ? eTag.trim() : null;
            this.refreshed = new AtomicLong(refreshed);
        }

        public V getEntry() {
            return this.entry;
        }

        public String getETag() {
            return this.eTag;
        }

        public void refresh(long refreshed) {
            this.refreshed.set(refreshed);
        }

        public long refreshed() {
            return this.refreshed.get();
        }
    }
}

