/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.path;

import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.services.utils.path.CdsResourcePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CdsResourcePathBuilder {
    private CdsResourcePathImpl cdsResourcePath;

    public static CdsResourcePathBuilder cds(CdsDefinition cdsDefinition) {
        CdsResourcePathBuilder builder = new CdsResourcePathBuilder();
        builder.cdsResourcePath = new CdsResourcePathImpl(cdsDefinition);
        return builder;
    }

    public CdsResourcePathBuilder path(String ... paths) {
        this.cdsResourcePath.setPaths(paths);
        return this;
    }

    public CdsResourcePathBuilder isPublic(boolean isPublic) {
        this.cdsResourcePath.isPublic = isPublic;
        return this;
    }

    public CdsResourcePathBuilder publicEvents(Stream<String> publicEvents) {
        publicEvents.collect(Collectors.toCollection(() -> this.cdsResourcePath.publicHttpMethods));
        return this;
    }

    public CdsResourcePathBuilder subPath(CdsResourcePath subPath) {
        if (!this.cdsResourcePath.subPaths.stream().anyMatch(sp -> sp.getPath().equals(subPath.getPath()))) {
            this.cdsResourcePath.subPaths.add(subPath);
        }
        return this;
    }

    public CdsResourcePathBuilder subPaths(Stream<CdsResourcePath> subPaths) {
        subPaths.forEach(subPath -> this.subPath((CdsResourcePath)subPath));
        return this;
    }

    public CdsResourcePath build() {
        this.cdsResourcePath.consolidate();
        return this.cdsResourcePath;
    }

    private static class CdsResourcePathImpl
    implements CdsResourcePath {
        protected String path;
        protected boolean isPublic;
        protected final CdsDefinition cdsDefinition;
        protected Set<String> publicHttpMethods = new HashSet<String>();
        protected List<CdsResourcePath> subPaths = new ArrayList<CdsResourcePath>();

        protected CdsResourcePathImpl(CdsDefinition cdsDefinition) {
            this.cdsDefinition = cdsDefinition;
            this.path = cdsDefinition.getName();
        }

        protected void setPaths(String ... paths) {
            this.path = CdsResourcePathImpl.append(paths);
        }

        protected void consolidate() {
            if (this.isPublic) {
                this.publicHttpMethods.clear();
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isPublic() {
            return this.isPublic;
        }

        @Override
        public Stream<String> publicEvents() {
            return this.publicHttpMethods.stream();
        }

        @Override
        public Stream<CdsResourcePath> subPaths() {
            return this.subPaths.stream();
        }

        @Override
        public CdsDefinition getCdsDefinition() {
            return this.cdsDefinition;
        }

        private static String normalize(String path) {
            String[] pathParts = path.replaceAll("\\s+", "").split("\\.");
            return Stream.of(pathParts).filter(part -> part != null && !part.isEmpty()).collect(Collectors.joining("."));
        }

        private static String append(String ... pathParts) {
            return Stream.of(pathParts).map(CdsResourcePathImpl::normalize).collect(Collectors.joining("."));
        }
    }
}

